/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java.bridges;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.issue.Issuable;
import org.sonar.api.issue.Issue;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Directory;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.ActiveRule;
import org.sonar.java.SonarComponents;
import org.sonar.java.checks.PackageInfoCheck;
import org.sonar.plugins.java.Bridges;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.squidbridge.api.CheckMessage;
import org.sonar.squidbridge.api.SourceFile;

public class ChecksBridge {
    private final Iterable<Checks<JavaCheck>> checks;
    private final ResourcePerspectives resourcePerspectives;
    private final RulesProfile rulesProfile;
    private Set<Directory> dirsWithoutPackageInfo;

    public ChecksBridge(SonarComponents sonarComponents, RulesProfile rulesProfile) {
        this.checks = sonarComponents.checks();
        this.resourcePerspectives = sonarComponents.getResourcePerspectives();
        this.rulesProfile = rulesProfile;
    }

    public void reportIssues(SourceFile squidFile, Resource sonarFile, @Nullable Bridges.ProjectIssue project) {
        if (squidFile.hasCheckMessages()) {
            Issuable issuable = (Issuable)this.resourcePerspectives.as(Issuable.class, sonarFile);
            Set messages = squidFile.getCheckMessages();
            if (issuable != null) {
                for (CheckMessage checkMessage : messages) {
                    Object check = checkMessage.getCheck();
                    RuleKey ruleKey = this.getRuleKey((JavaCheck)check);
                    if (ruleKey == null) {
                        throw new IllegalStateException("Cannot find rule key for instance of " + check.getClass());
                    }
                    if (project == null) {
                        Issue issue = issuable.newIssueBuilder().ruleKey(ruleKey).line(checkMessage.getLine()).message(checkMessage.formatDefaultMessage()).effortToFix(checkMessage.getCost()).build();
                        issuable.addIssue(issue);
                        continue;
                    }
                    project.addIssue(ruleKey, sonarFile.getKey(), checkMessage.getLine());
                }
            }
            messages.clear();
        }
    }

    @CheckForNull
    private RuleKey getRuleKey(JavaCheck check) {
        for (Checks<JavaCheck> sonarChecks : this.checks) {
            RuleKey ruleKey = sonarChecks.ruleKey((Object)check);
            if (ruleKey == null) continue;
            return ruleKey;
        }
        return null;
    }

    @CheckForNull
    private JavaCheck checkInstanceOf(RuleKey ruleKey) {
        for (Checks<JavaCheck> sonarChecks : this.checks) {
            JavaCheck check = (JavaCheck)sonarChecks.of(ruleKey);
            if (check == null) continue;
            return check;
        }
        return null;
    }

    public void reportIssueForPackageInfo(Directory directory, Project project, @Nullable Bridges.ProjectIssue projectIssue) {
        if (this.dirsWithoutPackageInfo == null) {
            this.initSetOfDirs(project);
        }
        if (this.dirsWithoutPackageInfo.contains(directory)) {
            RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S1228");
            if (projectIssue != null) {
                projectIssue.addIssue(ruleKey, directory.getKey(), null);
            } else {
                Issuable issuable = (Issuable)this.resourcePerspectives.as(Issuable.class, (Resource)directory);
                if (issuable != null) {
                    Issue issue = issuable.newIssueBuilder().ruleKey(ruleKey).message("Add a 'package-info.java' file to document the '" + directory.getPath() + "' package").build();
                    issuable.addIssue(issue);
                }
            }
        }
    }

    private void initSetOfDirs(Project project) {
        JavaCheck check;
        this.dirsWithoutPackageInfo = Sets.newHashSet();
        ActiveRule activeRule = this.rulesProfile.getActiveRule("squid", "S1228");
        if (activeRule != null && (check = this.checkInstanceOf(activeRule.getRule().ruleKey())) != null) {
            Set dirs = ((PackageInfoCheck)check).getDirectoriesWithoutPackageFile();
            for (File dir : dirs) {
                this.dirsWithoutPackageInfo.add(Directory.fromIOFile((File)dir, (Project)project));
            }
        }
    }
}

