/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.collect.Iterables;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.server.debt.DebtRemediationFunction;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.server.rule.RulesDefinitionAnnotationLoader;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.check.Cardinality;
import org.sonar.check.Rule;
import org.sonar.java.RspecKey;
import org.sonar.java.checks.CheckList;
import org.sonar.squidbridge.annotations.RuleTemplate;
import org.sonar.squidbridge.rules.ExternalDescriptionLoader;

public class JavaRulesDefinition
implements RulesDefinition {
    private static final String RESOURCE_BASE_PATH = "/org/sonar/l10n/java/rules/squid";
    private final Gson gson = new Gson();

    public void define(RulesDefinition.Context context) {
        RulesDefinition.NewRepository repository = context.createRepository("squid", "java").setName("SonarQube");
        List checks = CheckList.getChecks();
        new RulesDefinitionAnnotationLoader().load((RulesDefinition.NewExtendedRepository)repository, (Class[])Iterables.toArray((Iterable)checks, Class.class));
        for (Class ruleClass : checks) {
            this.newRule(ruleClass, repository);
        }
        repository.done();
    }

    @VisibleForTesting
    protected void newRule(Class<?> ruleClass, RulesDefinition.NewRepository repository) {
        Rule ruleAnnotation = (Rule)AnnotationUtils.getAnnotation(ruleClass, Rule.class);
        if (ruleAnnotation == null) {
            throw new IllegalArgumentException("No Rule annotation was found on " + ruleClass);
        }
        String ruleKey = ruleAnnotation.key();
        if (StringUtils.isEmpty((String)ruleKey)) {
            throw new IllegalArgumentException("No key is defined in Rule annotation of " + ruleClass);
        }
        RulesDefinition.NewRule rule = repository.rule(ruleKey);
        if (rule == null) {
            throw new IllegalStateException("No rule was created for " + ruleClass + " in " + repository.key());
        }
        rule.setTemplate(AnnotationUtils.getAnnotation(ruleClass, RuleTemplate.class) != null);
        if (ruleAnnotation.cardinality() == Cardinality.MULTIPLE) {
            throw new IllegalArgumentException("Cardinality is not supported, use the RuleTemplate annotation instead for " + ruleClass);
        }
        this.ruleMetadata(ruleClass, rule);
    }

    private void ruleMetadata(Class<?> ruleClass, RulesDefinition.NewRule rule) {
        String metadataKey = rule.key();
        RspecKey rspecKeyAnnotation = (RspecKey)AnnotationUtils.getAnnotation(ruleClass, RspecKey.class);
        if (rspecKeyAnnotation != null) {
            metadataKey = rspecKeyAnnotation.value();
            rule.setInternalKey(metadataKey);
        }
        JavaRulesDefinition.addHtmlDescription(rule, metadataKey);
        this.addMetadata(rule, metadataKey);
    }

    private void addMetadata(RulesDefinition.NewRule rule, String metadataKey) {
        URL resource = ExternalDescriptionLoader.class.getResource("/org/sonar/l10n/java/rules/squid/" + metadataKey + "_java.json");
        if (resource != null) {
            RuleMetatada metatada = (RuleMetatada)this.gson.fromJson(JavaRulesDefinition.readResource(resource), RuleMetatada.class);
            rule.setSeverity(metatada.defaultSeverity.toUpperCase());
            rule.setName(metatada.title);
            rule.addTags(metatada.tags);
            rule.setStatus(RuleStatus.valueOf((String)metatada.status.toUpperCase()));
            if (metatada.remediation != null) {
                rule.setDebtRemediationFunction(metatada.remediation.remediationFunction(rule.debtRemediationFunctions()));
                rule.setGapDescription(metatada.remediation.linearDesc);
            }
        }
    }

    private static void addHtmlDescription(RulesDefinition.NewRule rule, String metadataKey) {
        URL resource = JavaRulesDefinition.class.getResource("/org/sonar/l10n/java/rules/squid/" + metadataKey + "_java.html");
        if (resource != null) {
            rule.setHtmlDescription(JavaRulesDefinition.readResource(resource));
        }
    }

    private static String readResource(URL resource) {
        try {
            return Resources.toString((URL)resource, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read: " + resource, e);
        }
    }

    private static class Remediation {
        String func;
        String constantCost;
        String linearDesc;
        String linearOffset;
        String linearFactor;

        private Remediation() {
        }

        public DebtRemediationFunction remediationFunction(RulesDefinition.DebtRemediationFunctions drf) {
            if (this.func.startsWith("Constant")) {
                return drf.constantPerIssue(this.constantCost.replace("mn", "min"));
            }
            if ("Linear".equals(this.func)) {
                return drf.linear(this.linearFactor.replace("mn", "min"));
            }
            return drf.linearWithOffset(this.linearFactor.replace("mn", "min"), this.linearOffset.replace("mn", "min"));
        }
    }

    private static class RuleMetatada {
        String title;
        String status;
        @Nullable
        Remediation remediation;
        String[] tags;
        String defaultSeverity;

        private RuleMetatada() {
        }
    }
}

