/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks.verifier;

import com.google.common.primitives.Ints;
import java.util.List;
import javax.annotation.Nullable;

class TestIssue {
    private String message;
    private final int line;
    private Integer effortToFix = null;
    private Integer startColumn = null;
    private Integer endColumn = null;
    private Integer endLine = null;
    private List<Integer> secondaryLines = null;

    private TestIssue(@Nullable String message, int line) {
        this.message = message;
        this.line = line;
    }

    public static TestIssue create(@Nullable String message, int lineNumber) {
        return new TestIssue(message, lineNumber);
    }

    public TestIssue message(String message) {
        this.message = message;
        return this;
    }

    public TestIssue columns(int startColumn, int endColumn) {
        this.startColumn(startColumn);
        this.endColumn(endColumn);
        return this;
    }

    public TestIssue startColumn(int startColumn) {
        this.startColumn = startColumn;
        return this;
    }

    public TestIssue endColumn(int endColumn) {
        this.endColumn = endColumn;
        return this;
    }

    public TestIssue effortToFix(int effortToFix) {
        this.effortToFix = effortToFix;
        return this;
    }

    public TestIssue endLine(int endLine) {
        this.endLine = endLine;
        return this;
    }

    public TestIssue secondary(int ... lines) {
        return this.secondary(Ints.asList((int[])lines));
    }

    public TestIssue secondary(List<Integer> secondaryLines) {
        this.secondaryLines = secondaryLines;
        return this;
    }

    public int line() {
        return this.line;
    }

    public Integer startColumn() {
        return this.startColumn;
    }

    public Integer endLine() {
        return this.endLine;
    }

    public Integer endColumn() {
        return this.endColumn;
    }

    public String message() {
        return this.message;
    }

    public Integer effortToFix() {
        return this.effortToFix;
    }

    public List<Integer> secondaryLines() {
        return this.secondaryLines;
    }
}

