/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks.verifier;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sonar.javascript.checks.verifier.TestUtils;
import org.sonar.javascript.visitors.JavaScriptVisitorContext;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.visitors.FileIssue;
import org.sonar.plugins.javascript.api.visitors.Issue;
import org.sonar.plugins.javascript.api.visitors.LineIssue;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;
import org.sonar.plugins.javascript.api.visitors.TreeVisitorContext;
import org.sonar.squidbridge.api.CheckMessage;

class TreeCheckTest {
    private TreeCheckTest() {
    }

    public static Collection<CheckMessage> getIssues(String relativePath, JavaScriptCheck check) {
        File file = new File(relativePath);
        JavaScriptVisitorContext context = TestUtils.createContext(file);
        List issues = check.scanFile((TreeVisitorContext)context);
        return TreeCheckTest.getCheckMessages(issues);
    }

    private static Collection<CheckMessage> getCheckMessages(List<Issue> issues) {
        ArrayList<CheckMessage> checkMessages = new ArrayList<CheckMessage>();
        for (Issue issue : issues) {
            CheckMessage checkMessage;
            if (issue instanceof FileIssue) {
                FileIssue fileIssue = (FileIssue)issue;
                checkMessage = new CheckMessage((Object)fileIssue.check(), fileIssue.message(), new Object[0]);
            } else if (issue instanceof LineIssue) {
                LineIssue lineIssue = (LineIssue)issue;
                checkMessage = new CheckMessage((Object)lineIssue.check(), lineIssue.message(), new Object[0]);
                checkMessage.setLine(lineIssue.line());
            } else {
                PreciseIssue preciseIssue = (PreciseIssue)issue;
                checkMessage = new CheckMessage((Object)preciseIssue.check(), preciseIssue.primaryLocation().message(), new Object[0]);
                checkMessage.setLine(preciseIssue.primaryLocation().startLine());
            }
            if (issue.cost() != null) {
                checkMessage.setCost(issue.cost().doubleValue());
            }
            checkMessages.add(checkMessage);
        }
        return checkMessages;
    }
}

