/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.lexer.JavaScriptKeyword;
import org.sonar.javascript.tree.JavaScriptCommentAnalyser;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxTrivia;
import org.sonar.plugins.javascript.api.visitors.SubscriptionBaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.recognizer.CodeRecognizer;
import org.sonar.squidbridge.recognizer.Detector;
import org.sonar.squidbridge.recognizer.EndWithDetector;
import org.sonar.squidbridge.recognizer.KeywordsDetector;
import org.sonar.squidbridge.recognizer.LanguageFootprint;

@Rule(key="CommentedCode", name="Sections of code should not be \"commented out\"", priority=Priority.MAJOR, tags={"misra", "unused"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class CommentedCodeCheck
extends SubscriptionBaseTreeVisitor {
    private static final String MESSAGE = "Remove this commented out code.";
    private static final JavaScriptCommentAnalyser COMMENT_ANALYSER = new JavaScriptCommentAnalyser();
    private static final double THRESHOLD = 0.9;
    private final CodeRecognizer codeRecognizer = new CodeRecognizer(0.9, (LanguageFootprint)new JavaScriptRecognizer());
    private final Pattern regexpToDivideStringByLine = Pattern.compile("(\r?\n)|(\r)");

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.TOKEN);
    }

    public void visitNode(Tree tree) {
        SyntaxToken token = (SyntaxToken)tree;
        block0: for (SyntaxTrivia trivia : token.trivias()) {
            if (CommentedCodeCheck.isJsDoc(trivia) || CommentedCodeCheck.isJsLint(trivia) || CommentedCodeCheck.isJsHint(trivia) || CommentedCodeCheck.isGlobals(trivia)) continue;
            String[] lines = this.regexpToDivideStringByLine.split(COMMENT_ANALYSER.getContents(trivia.text()));
            for (int lineOffset = 0; lineOffset < lines.length; ++lineOffset) {
                if (!this.codeRecognizer.isLineOfCode(lines[lineOffset])) continue;
                this.getContext().addIssue((JavaScriptCheck)this, trivia.line() + lineOffset, MESSAGE);
                continue block0;
            }
        }
    }

    private static boolean isJsDoc(SyntaxTrivia trivia) {
        return trivia.text().startsWith("/**");
    }

    private static boolean isJsLint(SyntaxTrivia trivia) {
        return trivia.text().startsWith("/*jslint");
    }

    private static boolean isJsHint(SyntaxTrivia trivia) {
        return trivia.text().startsWith("/*jshint");
    }

    private static boolean isGlobals(SyntaxTrivia trivia) {
        return trivia.text().startsWith("/*global");
    }

    private static class ContainsDetectorJS
    extends Detector {
        private final List<String> strs;

        public ContainsDetectorJS(double probability, String ... strs) {
            super(probability);
            this.strs = Arrays.asList(strs);
        }

        public int scan(String line) {
            int matchers = 0;
            for (String str : this.strs) {
                matchers += StringUtils.countMatches((String)line, (String)str);
            }
            return matchers;
        }
    }

    private static class JavaScriptRecognizer
    implements LanguageFootprint {
        private JavaScriptRecognizer() {
        }

        public Set<Detector> getDetectors() {
            return ImmutableSet.of((Object)new EndWithDetector(0.95, new char[]{'}', ';', '{'}), (Object)new KeywordsDetector(0.3, JavaScriptKeyword.keywordValues()), (Object)((Object)new ContainsDetectorJS(0.95, "*=", "/=", "%=", "+=", "-=", "<<=", ">>=", ">>>=", "&=", "^=", "|=")), (Object)((Object)new ContainsDetectorJS(0.95, "!=", "!==")));
        }
    }
}

