/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxTrivia;
import org.sonar.plugins.javascript.api.visitors.SubscriptionBaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="ConditionalComment", name="Internet Explorer's conditional comments should not be used", priority=Priority.MAJOR, tags={"cross-browser"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class ConditionalCommentCheck
extends SubscriptionBaseTreeVisitor {
    private static final String MESSAGE = "Refactor your code to avoid using Internet Explorer's conditional comments.";

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.TOKEN);
    }

    public void visitNode(Tree tree) {
        SyntaxToken token = (SyntaxToken)tree;
        for (SyntaxTrivia trivia : token.trivias()) {
            String comment = trivia.text();
            if (!comment.startsWith("/*@cc_on") && !comment.startsWith("//@cc_on")) continue;
            this.getContext().addIssue((JavaScriptCheck)this, (Tree)trivia, MESSAGE);
        }
    }
}

