/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.LinkedList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.SymbolModel;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1854", name="Dead Stores should be removed", priority=Priority.MAJOR, tags={"bug", "cert", "cwe", "unused"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="DATA_RELIABILITY")
@SqaleConstantRemediation(value="15min")
public class DeadStoreCheck
extends BaseTreeVisitor {
    private static final String MESSAGE = "Remove this useless assignment to local variable \"%s\"";

    public void visitScript(ScriptTree tree) {
        SymbolModel symbolModel = this.getContext().getSymbolModel();
        for (Symbol symbol : symbolModel.getSymbols()) {
            this.visitSymbol(symbol);
        }
    }

    private void visitSymbol(Symbol symbol) {
        Scope scope = symbol.scope();
        if (scope.isGlobal()) {
            return;
        }
        LinkedList<Usage> usages = new LinkedList<Usage>(symbol.usages());
        if (!DeadStoreCheck.hasRead(usages)) {
            for (Usage usage : usages) {
                if (usage.isDeclaration() || usage.kind() == Usage.Kind.LEXICAL_DECLARATION) continue;
                this.getContext().addIssue((JavaScriptCheck)this, (Tree)usage.identifierTree(), String.format(MESSAGE, symbol.name()));
            }
        }
    }

    private static boolean hasRead(List<Usage> usages) {
        for (Usage usage : usages) {
            if (!usage.kind().equals((Object)Usage.Kind.READ) && !usage.kind().equals((Object)Usage.Kind.READ_WRITE)) continue;
            return true;
        }
        return false;
    }
}

