/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.Collections;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S3001", name="\"delete\" should be used only with object properties", priority=Priority.CRITICAL, tags={"bug"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="ARCHITECTURE_RELIABILITY")
@SqaleConstantRemediation(value="10min")
public class DeleteNonPropertyCheck
extends BaseTreeVisitor {
    private static final String MESSAGE = "Remove this \"delete\" operator or pass an object property to it.";

    public void visitUnaryExpression(UnaryExpressionTree tree) {
        ExpressionTree argument = CheckUtils.removeParenthesis(tree.expression());
        if (tree.is(new Tree.Kind[]{Tree.Kind.DELETE}) && !DeleteNonPropertyCheck.isMemberAccess(argument) && !DeleteNonPropertyCheck.isGlobalProperty(argument)) {
            this.raiseIssue(tree);
        }
        super.visitUnaryExpression(tree);
    }

    private static boolean isGlobalProperty(ExpressionTree expression) {
        Symbol symbol;
        if (expression instanceof IdentifierTree && (symbol = ((IdentifierTree)expression).symbol()) != null) {
            for (Usage usage : symbol.usages()) {
                if (!usage.isDeclaration()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isMemberAccess(ExpressionTree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.DOT_MEMBER_EXPRESSION, Tree.Kind.BRACKET_MEMBER_EXPRESSION});
    }

    private void raiseIssue(UnaryExpressionTree tree) {
        this.getContext().addIssue((JavaScriptCheck)this, new IssueLocation((Tree)tree, MESSAGE), Collections.emptyList(), null);
    }
}

