/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.EscapeUtils;
import org.sonar.javascript.tree.impl.declaration.ParameterListTreeImpl;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.ParameterListTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="DuplicateFunctionArgument", name="Function argument names should be unique", priority=Priority.CRITICAL, tags={"pitfall"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class DuplicateFunctionArgumentCheck
extends BaseTreeVisitor {
    private static final String MESSAGE = "Rename the duplicated function parameter%s %s.";

    public void visitParameterList(ParameterListTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.FORMAL_PARAMETER_LIST})) {
            ArrayList<String> duplicatedParameters = new ArrayList<String>();
            HashSet values = Sets.newHashSet();
            for (IdentifierTree identifier : ((ParameterListTreeImpl)tree).parameterIdentifiers()) {
                String value = identifier.name();
                String unescaped = EscapeUtils.unescape(value);
                if (values.contains(unescaped)) {
                    duplicatedParameters.add(value);
                    continue;
                }
                values.add(unescaped);
            }
            this.checkDuplicatedParameters(tree, duplicatedParameters);
        }
        super.visitParameterList(tree);
    }

    private void checkDuplicatedParameters(ParameterListTree tree, List<String> duplicatedParameters) {
        if (!duplicatedParameters.isEmpty()) {
            String message = String.format(MESSAGE, duplicatedParameters.size() > 1 ? "s" : "", DuplicateFunctionArgumentCheck.parameterListString(duplicatedParameters));
            this.getContext().addIssue((JavaScriptCheck)this, (Tree)tree, message);
        }
    }

    private static String parameterListString(List<String> duplicatedParameters) {
        return "\"" + Joiner.on((String)"\", \"").join(duplicatedParameters) + "\"";
    }
}

