/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.GeneratorMethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S100", name="Function names should comply with a naming convention", priority=Priority.MINOR, tags={"convention"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="5min")
public class FunctionNameCheck
extends BaseTreeVisitor {
    public static final String DEFAULT = "^[a-z][a-zA-Z0-9]*$";
    private static final String MESSAGE = "Rename this '%s' function to match the regular expression %s";
    private Pattern pattern = null;
    @RuleProperty(key="format", description="Regular expression used to check the function names against.", defaultValue="^[a-z][a-zA-Z0-9]*$")
    public String format = "^[a-z][a-zA-Z0-9]*$";

    public void visitScript(ScriptTree tree) {
        this.pattern = Pattern.compile(this.format);
        super.visitScript(tree);
    }

    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        this.checkName(tree.name());
        super.visitMethodDeclaration(tree);
    }

    public void visitGeneratorMethodDeclaration(GeneratorMethodDeclarationTree tree) {
        this.checkName(tree.name());
        super.visitGeneratorMethodDeclaration(tree);
    }

    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.checkName((ExpressionTree)tree.name());
        super.visitFunctionDeclaration(tree);
    }

    private void checkName(@Nullable ExpressionTree tree) {
        if (tree != null) {
            String name;
            String string = name = tree instanceof IdentifierTree ? ((IdentifierTree)tree).name() : CheckUtils.asString((Tree)tree);
            if (!this.pattern.matcher(name).matches()) {
                this.getContext().addIssue((JavaScriptCheck)this, (Tree)tree, String.format(MESSAGE, name, this.format));
            }
        }
    }
}

