/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.symbols.type.Backbone;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ObjectLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.PairPropertyTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2550", name="\"defaults\" should be a function when objects or arrays are used", priority=Priority.CRITICAL, tags={"backbone", "bug"})
@SqaleSubCharacteristic(value="DATA_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class ModelDefaultsWithArrayOrObjectCheck
extends BaseTreeVisitor {
    private static final String MESSAGE = "Make \"defaults\" a function.";

    public void visitCallExpression(CallExpressionTree tree) {
        PairPropertyTree defaultsProp;
        Tree parameter;
        if (tree.types().contains(Type.Kind.BACKBONE_MODEL) && !tree.arguments().parameters().isEmpty() && (parameter = (Tree)tree.arguments().parameters().get(0)).is(new Tree.Kind[]{Tree.Kind.OBJECT_LITERAL}) && (defaultsProp = Backbone.getModelProperty((ObjectLiteralTree)((ObjectLiteralTree)parameter), (String)"defaults")) != null && defaultsProp.value().is(new Tree.Kind[]{Tree.Kind.OBJECT_LITERAL}) && ModelDefaultsWithArrayOrObjectCheck.hasObjectOrArrayAttribute((ObjectLiteralTree)defaultsProp.value())) {
            this.getContext().addIssue((JavaScriptCheck)this, (Tree)defaultsProp, MESSAGE);
        }
        super.visitCallExpression(tree);
    }

    private static boolean hasObjectOrArrayAttribute(ObjectLiteralTree objectLiteral) {
        for (Tree property : objectLiteral.properties()) {
            if (!property.is(new Tree.Kind[]{Tree.Kind.PAIR_PROPERTY}) || !((PairPropertyTree)property).value().is(new Tree.Kind[]{Tree.Kind.ARRAY_LITERAL, Tree.Kind.OBJECT_LITERAL})) continue;
            return true;
        }
        return false;
    }
}

