/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.StatementTree;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;
import org.sonar.plugins.javascript.api.visitors.SubscriptionBaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="OneStatementPerLine", name="Statements should be on separate lines", priority=Priority.MINOR, tags={"convention"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="1min")
public class OneStatementPerLineCheck
extends SubscriptionBaseTreeVisitor {
    private static final String MESSAGE = "Reformat the code to have only one statement per line.";
    private ListMultimap<Integer, StatementTree> statementsPerLine = ArrayListMultimap.create();
    private List<StatementTree> excludedStatements = new ArrayList<StatementTree>();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.VARIABLE_STATEMENT, (Object)Tree.Kind.EXPRESSION_STATEMENT, (Object)Tree.Kind.IF_STATEMENT, (Object)Tree.Kind.DO_WHILE_STATEMENT, (Object)Tree.Kind.WHILE_STATEMENT, (Object)Tree.Kind.FOR_IN_STATEMENT, (Object)Tree.Kind.FOR_OF_STATEMENT, (Object)Tree.Kind.FOR_STATEMENT, (Object)Tree.Kind.CONTINUE_STATEMENT, (Object)Tree.Kind.BREAK_STATEMENT, (Object)Tree.Kind.RETURN_STATEMENT, (Object)Tree.Kind.WITH_STATEMENT, (Object[])new Tree.Kind[]{Tree.Kind.SWITCH_STATEMENT, Tree.Kind.THROW_STATEMENT, Tree.Kind.TRY_STATEMENT, Tree.Kind.DEBUGGER_STATEMENT, Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.SCRIPT});
    }

    public void visitFile(Tree scriptTree) {
        this.statementsPerLine.clear();
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.FUNCTION_EXPRESSION})) {
            this.checkFunctionExpressionException((FunctionExpressionTree)tree);
        }
        if (!tree.is(new Tree.Kind[]{Tree.Kind.SCRIPT, Tree.Kind.FUNCTION_EXPRESSION}) && !this.excludedStatements.contains(tree)) {
            this.statementsPerLine.put((Object)((JavaScriptTree)tree).getLine(), (Object)((StatementTree)tree));
        }
    }

    private void checkFunctionExpressionException(FunctionExpressionTree functionExpressionTree) {
        int line = ((JavaScriptTree)functionExpressionTree).getLine();
        List statements = functionExpressionTree.body().statements();
        if (statements.size() == 1 && ((JavaScriptTree)statements.get(0)).getLine() == line && this.statementsPerLine.containsKey((Object)line)) {
            this.excludedStatements.add((StatementTree)statements.get(0));
        }
    }

    public void leaveNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.SCRIPT})) {
            Iterator i$ = this.statementsPerLine.keys().elementSet().iterator();
            while (i$.hasNext()) {
                int line = (Integer)i$.next();
                List statementsAtLine = this.statementsPerLine.get((Object)line);
                if (statementsAtLine.size() <= 1) continue;
                this.addIssue(statementsAtLine);
            }
        }
    }

    private void addIssue(List<StatementTree> statementsAtLine) {
        IssueLocation primaryLocation = new IssueLocation((Tree)statementsAtLine.get(1), MESSAGE);
        ArrayList<IssueLocation> secondaryLocations = new ArrayList<IssueLocation>();
        for (int i = 2; i < statementsAtLine.size(); ++i) {
            secondaryLocations.add(new IssueLocation((Tree)statementsAtLine.get(i)));
        }
        this.getContext().addIssue((JavaScriptCheck)this, primaryLocation, secondaryLocations, null);
    }
}

