/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.tree.statement.ExpressionStatementTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="StrictMode", name="\"strict\" mode should be used with caution", priority=Priority.INFO, tags={"cross-browser", "user-experience"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="ARCHITECTURE_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class StrictModeCheck
extends BaseTreeVisitor {
    private static final String MESSAGE = "Use of JavaScript strict mode may result in unexpected behaviour in some browsers.";

    public void visitExpressionStatement(ExpressionStatementTree tree) {
        String value;
        if (tree.expression().is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) && ("\"use strict\"".equals(value = ((LiteralTree)tree.expression()).value()) || "'use strict'".equals(value))) {
            this.getContext().addIssue((JavaScriptCheck)this, (Tree)tree, MESSAGE);
        }
        super.visitExpressionStatement(tree);
    }
}

