/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S3402", name="Strings and non-strings should not be added", priority=Priority.MAJOR, tags={"suspicious"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="15min")
public class StringConcatenatedWithNonStringCheck
extends BaseTreeVisitor {
    private static final String MESSAGE = "Either make this concatenation explicit or cast \"%s\" operand to a number.";

    public void visitBinaryExpression(BinaryExpressionTree tree) {
        ExpressionTree stringOperand;
        if (tree.is(new Tree.Kind[]{Tree.Kind.PLUS}) && (stringOperand = StringConcatenatedWithNonStringCheck.getOnlyStringOperand(tree.leftOperand(), tree.rightOperand())) != null && stringOperand.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE})) {
            this.raiseIssue(tree, stringOperand);
        }
        super.visitBinaryExpression(tree);
    }

    @CheckForNull
    private static ExpressionTree getOnlyStringOperand(ExpressionTree leftOperand, ExpressionTree rightOperand) {
        Type leftOperandType = leftOperand.types().getUniqueKnownType();
        Type rightOperandType = rightOperand.types().getUniqueKnownType();
        if (leftOperandType != null && rightOperandType != null) {
            if (StringConcatenatedWithNonStringCheck.isString(leftOperandType) && !StringConcatenatedWithNonStringCheck.isString(rightOperandType)) {
                return leftOperand;
            }
            if (!StringConcatenatedWithNonStringCheck.isString(leftOperandType) && StringConcatenatedWithNonStringCheck.isString(rightOperandType)) {
                return rightOperand;
            }
        }
        return null;
    }

    private void raiseIssue(BinaryExpressionTree tree, ExpressionTree stringOperand) {
        ImmutableList secondaryLocations = ImmutableList.of((Object)new IssueLocation((Tree)tree.leftOperand()), (Object)new IssueLocation((Tree)tree.rightOperand()));
        String message = String.format(MESSAGE, CheckUtils.asString((Tree)stringOperand));
        this.getContext().addIssue((JavaScriptCheck)this, new IssueLocation((Tree)tree.operator(), message), (List)secondaryLocations, null);
    }

    private static boolean isString(Type type) {
        return type.kind() == Type.Kind.STRING;
    }
}

