/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.visitors.CharsetAwareVisitor;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.plugins.javascript.api.visitors.TreeVisitorContext;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="TabCharacter", name="Tabulation characters should not be used", priority=Priority.MINOR, tags={"convention"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="2min")
public class TabCharacterCheck
extends BaseTreeVisitor
implements CharsetAwareVisitor {
    private static final String MESSAGE = "Replace all tab characters in this file by sequences of white-spaces.";
    private Charset charset;

    public void scanFile(TreeVisitorContext context) {
        super.scanFile(context);
        List lines = Collections.emptyList();
        try {
            lines = Files.readLines((File)this.getContext().getFile(), (Charset)this.charset);
        }
        catch (IOException e) {
            String fileName = this.getContext().getFile().getName();
            throw new IllegalStateException("Unable to execute rule \"TabCharacter\" for file " + fileName, e);
        }
        for (int i = 0; i < lines.size(); ++i) {
            if (!((String)lines.get(i)).contains("\t")) continue;
            this.getContext().addIssue((JavaScriptCheck)this, i + 1, MESSAGE);
            break;
        }
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }
}

