/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.NewExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionBaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S138", name="Functions should not have too many lines", priority=Priority.MAJOR, tags={"brain-overload"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="20min")
public class TooManyLinesInFunctionCheck
extends SubscriptionBaseTreeVisitor {
    private static final String MESSAGE = "This function has %s lines, which is greater than the %s lines authorized. Split it into smaller functions.";
    private static final int DEFAULT = 100;
    @RuleProperty(key="max", description="Maximum authorized lines in a function", defaultValue="100")
    public int max = 100;
    private boolean immediatelyInvokedFunctionExpression = false;
    private boolean amdPattern = false;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD, (Object)Tree.Kind.GENERATOR_METHOD, (Object)Tree.Kind.GENERATOR_DECLARATION, (Object)Tree.Kind.GENERATOR_FUNCTION_EXPRESSION, (Object)Tree.Kind.FUNCTION_DECLARATION, (Object)Tree.Kind.FUNCTION_EXPRESSION, (Object)Tree.Kind.CALL_EXPRESSION, (Object)Tree.Kind.NEW_EXPRESSION);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.CALL_EXPRESSION})) {
            this.checkForImmediatelyInvokedFunction(((CallExpressionTree)tree).callee());
            this.checkForAMDPattern((CallExpressionTree)tree);
            return;
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.NEW_EXPRESSION})) {
            if (((NewExpressionTree)tree).arguments() != null) {
                this.checkForImmediatelyInvokedFunction(((NewExpressionTree)tree).expression());
            }
            return;
        }
        int nbLines = TooManyLinesInFunctionCheck.getNumberOfLine(tree);
        if (nbLines > this.max && !this.immediatelyInvokedFunctionExpression && !this.amdPattern) {
            String message = String.format(MESSAGE, nbLines, this.max);
            this.getContext().addIssue((JavaScriptCheck)this, tree, message);
        }
        this.clearCheckState();
    }

    private void clearCheckState() {
        this.immediatelyInvokedFunctionExpression = false;
        this.amdPattern = false;
    }

    private void checkForAMDPattern(CallExpressionTree tree) {
        if (tree.callee().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE}) && "define".equals(((IdentifierTree)tree.callee()).name())) {
            for (Tree parameter : tree.arguments().parameters()) {
                if (!parameter.is(new Tree.Kind[]{Tree.Kind.FUNCTION_EXPRESSION})) continue;
                this.amdPattern = true;
            }
        }
    }

    private void checkForImmediatelyInvokedFunction(ExpressionTree callee) {
        boolean parenthesisedFunctionCallee;
        Tree.Kind[] funcExprKinds = new Tree.Kind[]{Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.GENERATOR_FUNCTION_EXPRESSION};
        boolean directFunctionCallee = callee.is(funcExprKinds);
        boolean bl = parenthesisedFunctionCallee = callee.is(new Tree.Kind[]{Tree.Kind.PARENTHESISED_EXPRESSION}) && ((ParenthesisedExpressionTree)callee).expression().is(funcExprKinds);
        if (directFunctionCallee || parenthesisedFunctionCallee) {
            this.immediatelyInvokedFunctionExpression = true;
        }
    }

    public static int getNumberOfLine(Tree tree) {
        Iterator childrenIterator = ((JavaScriptTree)tree).childrenIterator();
        while (childrenIterator.hasNext()) {
            Tree child = (Tree)childrenIterator.next();
            if (child == null || !child.is(new Tree.Kind[]{Tree.Kind.BLOCK})) continue;
            int firstLine = ((BlockTree)child).openCurlyBrace().line();
            int lastLine = ((BlockTree)child).closeCurlyBrace().line();
            return lastLine - firstLine + 1;
        }
        throw new IllegalStateException("No block child found for current tree.");
    }
}

