/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.tree.statement.ExpressionStatementTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S905", name="Non-empty statements should have at least one side-effect", priority=Priority.CRITICAL, tags={"bug", "cwe", "unused"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class UselessExpressionStatementCheck
extends BaseTreeVisitor {
    private static final String MESSAGE = "Refactor or remove this statement.";

    public void visitExpressionStatement(ExpressionStatementTree tree) {
        Tree expression = tree.expression();
        if (expression.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO})) {
            this.getContext().addIssue((JavaScriptCheck)this, (Tree)tree, MESSAGE);
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) && !UselessExpressionStatementCheck.isUseStrictDirective((LiteralTree)expression)) {
            this.getContext().addIssue((JavaScriptCheck)this, (Tree)tree, MESSAGE);
        }
        super.visitExpressionStatement(tree);
    }

    private static boolean isUseStrictDirective(LiteralTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            String value = tree.value();
            value = value.substring(1, value.length() - 1);
            return "use strict".equals(value);
        }
        return false;
    }
}

