/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ConditionalExpressionTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="ConditionalOperator", name="Avoid use of conditional operator", priority=Priority.MINOR, tags={"confusing"})
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class ConditionalOperatorCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Replace this conditional operator by a standard if/else control flow statement.";

    public void visitConditionalExpression(ConditionalExpressionTree tree) {
        this.addLineIssue((Tree)tree.query(), MESSAGE);
        super.visitConditionalExpression(tree);
    }
}

