/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="Eval", name="Code should not be dynamically injected and executed to prevent Eval Injection vulnerability", priority=Priority.CRITICAL, tags={"cwe", "owasp-a3", "security"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="INPUT_VALIDATION_AND_REPRESENTATION")
@SqaleConstantRemediation(value="30min")
public class EvalCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Remove this use of the \"eval\" function.";

    public void visitCallExpression(CallExpressionTree tree) {
        if (tree.callee().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE}) && "eval".equals(((IdentifierTree)tree.callee()).name())) {
            this.addLineIssue((Tree)tree, MESSAGE);
        }
        super.visitCallExpression(tree);
    }
}

