/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.Iterator;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1472", name="Function call arguments should not start on new line", priority=Priority.CRITICAL, tags={"pitfall"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class FunctionCallArgumentsOnNewLineCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Make those call arguments start on line %s";

    public void visitCallExpression(CallExpressionTree tree) {
        int argumentsLine;
        int calleeLastLine = this.getLastLine((Tree)tree.callee());
        if (calleeLastLine != (argumentsLine = ((JavaScriptTree)tree.arguments()).getLine())) {
            this.addLineIssue((Tree)tree.arguments(), String.format(MESSAGE, calleeLastLine));
        }
        super.visitCallExpression(tree);
    }

    private int getLastLine(Tree tree) {
        JavaScriptTree jsTree = (JavaScriptTree)tree;
        if (jsTree.isLeaf()) {
            return jsTree.getLine();
        }
        return this.getLastLine(this.getLastElement(jsTree.childrenIterator()));
    }

    public Tree getLastElement(Iterator<Tree> itr) {
        Tree lastElement = itr.next();
        while (itr.hasNext()) {
            lastElement = itr.next();
        }
        return lastElement;
    }
}

