/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.Issue;
import org.sonar.plugins.javascript.api.visitors.LineIssue;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="LineLength", name="Lines should not be too long", priority=Priority.MINOR, tags={"convention"})
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="1min")
public class LineLengthCheck
extends SubscriptionVisitorCheck {
    private static final String MESSAGE = "Split this %s characters long line (which is greater than %s authorized).";
    private SyntaxToken previousToken;
    private static final int DEFAULT_MAXIMUM_LINE_LENHGTH = 80;
    @RuleProperty(key="maximumLineLength", description="The maximum authorized line length.", defaultValue="80")
    public int maximumLineLength = 80;

    public int getMaximumLineLength() {
        return this.maximumLineLength;
    }

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.TOKEN);
    }

    public void visitFile(Tree tree) {
        this.previousToken = null;
    }

    public void visitNode(Tree tree) {
        int length;
        SyntaxToken token = (SyntaxToken)tree;
        if (this.previousToken != null && (this.previousToken.line() != token.line() || ((InternalSyntaxToken)token).isEOF()) && (length = this.previousToken.column() + this.previousToken.text().length()) > this.getMaximumLineLength()) {
            this.addIssue((Issue)new LineIssue((JavaScriptCheck)this, this.previousToken.line(), String.format(MESSAGE, length, this.getMaximumLineLength())));
        }
        this.previousToken = token;
    }
}

