/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.cfg.ControlFlowBlock;
import org.sonar.javascript.cfg.ControlFlowGraph;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.CaseClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.StatementTree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="NonEmptyCaseWithoutBreak", name="Switch cases should end with an unconditional \"break\" statement", priority=Priority.CRITICAL, tags={"cert", "cwe", "misra", "pitfall"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="10min")
public class NonEmptyCaseWithoutBreakCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "End this switch case with an unconditional break, continue, return or throw statement.";

    public void visitSwitchStatement(SwitchStatementTree tree) {
        HashSet<Tree> caseExpressions = new HashSet<Tree>();
        for (CaseClauseTree caseClause : Iterables.filter((Iterable)tree.cases(), CaseClauseTree.class)) {
            NonEmptyCaseWithoutBreakCheck.addCaseExpression(caseExpressions, caseClause.expression());
        }
        ControlFlowGraph cfg = this.getControlFlowGraph(tree);
        SwitchClauseTree previousClauseWithStatement = null;
        for (SwitchClauseTree switchClause : tree.cases()) {
            if (previousClauseWithStatement != null && (NonEmptyCaseWithoutBreakCheck.canBeFallenInto(switchClause, cfg, caseExpressions) || NonEmptyCaseWithoutBreakCheck.hasOnlyEmptyStatements(previousClauseWithStatement))) {
                this.addIssue((Tree)previousClauseWithStatement.keyword(), MESSAGE);
            }
            if (switchClause.statements().isEmpty()) continue;
            previousClauseWithStatement = switchClause;
        }
        super.visitSwitchStatement(tree);
    }

    private static void addCaseExpression(Set<Tree> caseExpressions, ExpressionTree expression) {
        caseExpressions.add((Tree)expression);
        if (expression.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_OR})) {
            BinaryExpressionTree binary = (BinaryExpressionTree)expression;
            NonEmptyCaseWithoutBreakCheck.addCaseExpression(caseExpressions, binary.leftOperand());
        }
    }

    private static boolean hasOnlyEmptyStatements(SwitchClauseTree switchClause) {
        return NonEmptyCaseWithoutBreakCheck.firstNonEmptyStatement(switchClause.statements()) == null;
    }

    private static boolean canBeFallenInto(SwitchClauseTree switchClause, ControlFlowGraph cfg, Set<Tree> caseExpressions) {
        StatementTree firstNonEmptyStatement = NonEmptyCaseWithoutBreakCheck.firstNonEmptyStatement(switchClause.statements());
        if (firstNonEmptyStatement == null) {
            return false;
        }
        ControlFlowBlock block = cfg.getStartingBlock(firstNonEmptyStatement);
        for (ControlFlowBlock predecessor : Iterables.filter((Iterable)block.predecessors(), ControlFlowBlock.class)) {
            int predecessorIndex;
            int statementIndex;
            List predecessorElements = predecessor.elements();
            Tree predecessorLastElement = (Tree)predecessorElements.get(predecessorElements.size() - 1);
            if (caseExpressions.contains(predecessorLastElement) || (statementIndex = NonEmptyCaseWithoutBreakCheck.tokenIndex((Tree)firstNonEmptyStatement)) <= (predecessorIndex = NonEmptyCaseWithoutBreakCheck.tokenIndex((Tree)predecessorElements.get(0)))) continue;
            return true;
        }
        return false;
    }

    private static int tokenIndex(Tree tree) {
        JavaScriptTree jsTree = (JavaScriptTree)tree;
        InternalSyntaxToken firstToken = (InternalSyntaxToken)jsTree.getFirstToken();
        return firstToken.startIndex();
    }

    private static StatementTree firstNonEmptyStatement(List<StatementTree> statements) {
        for (StatementTree statement : statements) {
            if (statement.is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
                StatementTree nestedFirstStatement = NonEmptyCaseWithoutBreakCheck.firstNonEmptyStatement(((BlockTree)statement).statements());
                if (nestedFirstStatement == null) continue;
                return nestedFirstStatement;
            }
            if (statement.is(new Tree.Kind[]{Tree.Kind.EMPTY_STATEMENT})) continue;
            return statement;
        }
        return null;
    }

    private ControlFlowGraph getControlFlowGraph(SwitchStatementTree tree) {
        Scope scope = this.getContext().getSymbolModel().getScope((Tree)tree);
        while (scope.isBlock()) {
            scope = scope.outer();
        }
        if (scope.isGlobal()) {
            return ControlFlowGraph.build((ScriptTree)this.getContext().getTopTree());
        }
        return ControlFlowGraph.build((BlockTree)((BlockTree)((FunctionTree)scope.tree()).body()));
    }
}

