/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="SingleQuote", name="Single quotes should be used for string literals", priority=Priority.MINOR, tags={"convention"})
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="1min")
public class SingleQuoteStringLiteralsCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Replace double quotes by simple quote";

    public void visitLiteral(LiteralTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) && tree.value().startsWith("\"")) {
            this.addLineIssue((Tree)tree, MESSAGE);
        }
    }
}

