/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S3512", name="Template strings should be used instead of concatenation", priority=Priority.MINOR, tags={"es2015", "clumsy"})
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="5min")
public class StringConcatenationCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Convert this concatenation to the use of a template.";
    private static final int MIN_LITERAL_LENGTH = 6;

    public void visitBinaryExpression(BinaryExpressionTree tree) {
        ImmutableList.Builder operandListBuilder = ImmutableList.builder();
        this.checkBinaryExpression(tree, (ImmutableList.Builder<ExpressionTree>)operandListBuilder);
        ImmutableList operandList = operandListBuilder.build().reverse();
        if (StringConcatenationCheck.meetConditions((List<ExpressionTree>)operandList)) {
            this.addIssue((Tree)tree, MESSAGE);
        }
    }

    private static boolean meetConditions(List<ExpressionTree> operandList) {
        if (operandList.size() > 2) {
            int literalsNum = 0;
            int shortLiteralsNum = 0;
            for (ExpressionTree operand : operandList) {
                if (operand.is(new Tree.Kind[]{Tree.Kind.TEMPLATE_LITERAL, Tree.Kind.STRING_LITERAL})) {
                    ++literalsNum;
                }
                if (!operand.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) || ((LiteralTree)operand).value().length() >= 6) continue;
                ++shortLiteralsNum;
            }
            return literalsNum > 0 && (double)shortLiteralsNum <= (double)literalsNum / 2.0;
        }
        return false;
    }

    private void checkBinaryExpression(BinaryExpressionTree tree, ImmutableList.Builder<ExpressionTree> operandListBuilder) {
        operandListBuilder.add((Object)tree.rightOperand());
        this.scan((Tree)tree.rightOperand());
        if (tree.is(new Tree.Kind[]{Tree.Kind.PLUS})) {
            if (tree.leftOperand().is(new Tree.Kind[]{Tree.Kind.PLUS})) {
                this.checkBinaryExpression((BinaryExpressionTree)tree.leftOperand(), operandListBuilder);
            } else {
                operandListBuilder.add((Object)tree.leftOperand());
                this.scan((Tree)tree.leftOperand());
            }
        } else {
            this.scan((Tree)tree.leftOperand());
        }
    }
}

