/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.visitors.CharsetAwareVisitor;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.visitors.Issue;
import org.sonar.plugins.javascript.api.visitors.LineIssue;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="TrailingWhitespace", name="Lines should not end with trailing whitespaces", priority=Priority.MINOR, tags={"convention"})
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="1min")
public class TrailingWhitespaceCheck
extends SubscriptionVisitorCheck
implements CharsetAwareVisitor {
    private static final String MESSAGE = "Remove the useless trailing whitespaces at the end of this line.";
    private Charset charset;

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public List<Tree.Kind> nodesToVisit() {
        return Collections.emptyList();
    }

    public void visitFile(Tree scriptTree) {
        List lines = Collections.emptyList();
        try {
            lines = Files.readLines((File)this.getContext().getFile(), (Charset)this.charset);
        }
        catch (IOException e) {
            String fileName = this.getContext().getFile().getName();
            throw new IllegalStateException("Unable to execute rule \"TrailingWhitespace\" for file " + fileName, e);
        }
        for (int i = 0; i < lines.size(); ++i) {
            String line = (String)lines.get(i);
            if (line.length() <= 0 || !Pattern.matches("[\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]", line.subSequence(line.length() - 1, line.length()))) continue;
            this.addIssue((Issue)new LineIssue((JavaScriptCheck)this, i + 1, MESSAGE));
        }
    }
}

