/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S3002", name="Unary operators \"+\" and \"-\" should not be used with objects", priority=Priority.CRITICAL, tags={"bug"})
@SqaleSubCharacteristic(value="DATA_RELIABILITY")
@SqaleConstantRemediation(value="15min")
@ActivatedByDefault
public class UnaryPlusMinusWithObjectCheck
extends SubscriptionVisitorCheck {
    private static final String MESSAGE = "Remove this use of unary \"%s\".";
    private static final EnumSet<Type.Kind> ALLOWED_TYPES = EnumSet.of(Type.Kind.BOOLEAN, Type.Kind.NUMBER, Type.Kind.STRING);

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.builder().add((Object)Tree.Kind.UNARY_MINUS).add((Object)Tree.Kind.UNARY_PLUS).build();
    }

    public void visitNode(Tree tree) {
        boolean isDateException;
        Type type = ((UnaryExpressionTree)tree).expression().types().getUniqueKnownType();
        if (type != null && !(isDateException = UnaryPlusMinusWithObjectCheck.isDateException(tree, type)) && !ALLOWED_TYPES.contains(type.kind())) {
            String operator = ((UnaryExpressionTree)tree).operator().text();
            this.addLineIssue(tree, String.format(MESSAGE, operator));
        }
    }

    private static boolean isDateException(Tree tree, Type type) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.UNARY_PLUS})) {
            String exprString = CheckUtils.asString((Tree)((UnaryExpressionTree)tree).expression());
            boolean isDateName = exprString.contains("Date") || exprString.contains("date");
            return type.kind() == Type.Kind.DATE || isDateName;
        }
        return false;
    }
}

