/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.SetMultimap;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.cfg.CfgBlock;
import org.sonar.javascript.cfg.CfgBranchingBlock;
import org.sonar.javascript.cfg.ControlFlowGraph;
import org.sonar.javascript.se.BlockExecution;
import org.sonar.javascript.se.LocalVariables;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.SymbolicValue;
import org.sonar.javascript.se.Truthiness;
import org.sonar.javascript.tree.TreeKinds;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionTree;
import org.sonar.plugins.javascript.api.tree.declaration.InitializedBindingElementTree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.ForObjectStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.VariableDeclarationTree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2583", name="Conditions should not unconditionally evaluate to \"true\" or to \"false\"", priority=Priority.CRITICAL, tags={"bug", "cert", "cwe", "misra"})
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="15min")
@ActivatedByDefault
public class AlwaysTrueOrFalseConditionCheck
extends SubscriptionVisitorCheck {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.FUNCTION_DECLARATION, (Object)Tree.Kind.GENERATOR_DECLARATION, (Object)Tree.Kind.FUNCTION_EXPRESSION, (Object)Tree.Kind.GENERATOR_FUNCTION_EXPRESSION, (Object)Tree.Kind.METHOD, (Object)Tree.Kind.GENERATOR_METHOD, (Object)Tree.Kind.ARROW_FUNCTION);
    }

    public void visitNode(Tree tree) {
        FunctionTree functionTree = (FunctionTree)tree;
        if (functionTree.body().is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            this.checkCFG(ControlFlowGraph.build((BlockTree)((BlockTree)functionTree.body())), functionTree);
        }
    }

    private void checkCFG(ControlFlowGraph cfg, FunctionTree functionTree) {
        Scope functionScope = this.getContext().getSymbolModel().getScope((Tree)functionTree);
        new SymbolicExecution(functionScope, cfg).visitCfg();
    }

    private class SymbolicExecution {
        private static final int MAX_BLOCK_EXECUTIONS = 1000;
        private final CfgBlock cfgStartBlock;
        private final Set<Symbol> trackedVariables;
        private final Set<Symbol> functionParameters;
        private final Scope functionScope;
        private final Deque<BlockExecution> workList = new ArrayDeque<BlockExecution>();
        private final SetMultimap<Tree, Truthiness> conditionResults = HashMultimap.create();
        private final Set<BlockExecution> alreadyProcessed = new HashSet<BlockExecution>();

        public SymbolicExecution(Scope functionScope, ControlFlowGraph cfg) {
            this.cfgStartBlock = cfg.start();
            LocalVariables localVariables = new LocalVariables(functionScope, cfg);
            this.trackedVariables = localVariables.trackableVariables();
            this.functionParameters = localVariables.functionParameters();
            this.functionScope = functionScope;
        }

        public void visitCfg() {
            this.workList.addLast(new BlockExecution(this.cfgStartBlock, this.initialState()));
            for (int i = 0; i < 1000 && !this.workList.isEmpty(); ++i) {
                BlockExecution blockExecution = this.workList.removeFirst();
                if (this.alreadyProcessed.contains(blockExecution)) continue;
                if (this.hasTryBranchingTree(blockExecution.block())) {
                    return;
                }
                this.execute(blockExecution);
                this.alreadyProcessed.add(blockExecution);
            }
            if (this.workList.isEmpty()) {
                this.reportIssues();
            }
        }

        private boolean hasTryBranchingTree(CfgBlock block) {
            if (block instanceof CfgBranchingBlock) {
                return ((CfgBranchingBlock)block).branchingTree().is(new Tree.Kind[]{Tree.Kind.TRY_STATEMENT});
            }
            return false;
        }

        private ProgramState initialState() {
            ProgramState initialState = ProgramState.emptyState();
            for (Symbol localVar : this.trackedVariables) {
                SymbolicValue initialValue = this.functionParameters.contains(localVar) ? SymbolicValue.UNKNOWN : SymbolicValue.NULL_OR_UNDEFINED;
                initialState = initialState.copyAndAddValue(localVar, initialValue);
            }
            Symbol arguments = this.functionScope.getSymbol("arguments");
            initialState = initialState.copyAndAddValue(arguments, SymbolicValue.UNKNOWN);
            initialState = initialState.constrain(arguments, Truthiness.TRUTHY);
            return initialState;
        }

        private void reportIssues() {
            for (Map.Entry entry : this.conditionResults.asMap().entrySet()) {
                Collection results = (Collection)entry.getValue();
                if (results.size() != 1 || Truthiness.UNKNOWN.equals(results.iterator().next())) continue;
                String result = Truthiness.TRUTHY.equals(results.iterator().next()) ? "true" : "false";
                AlwaysTrueOrFalseConditionCheck.this.addIssue((Tree)entry.getKey(), String.format("Change this condition so that it does not always evaluate to \"%s\".", result));
            }
        }

        private void execute(BlockExecution blockExecution) {
            CfgBlock block = blockExecution.block();
            ProgramState currentState = blockExecution.state();
            for (Tree element : block.elements()) {
                AssignmentExpressionTree assignment;
                if (element.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
                    assignment = (AssignmentExpressionTree)element;
                    currentState = this.store(currentState, (Tree)assignment.variable(), assignment.expression());
                    continue;
                }
                if (TreeKinds.isAssignment((Tree)element)) {
                    assignment = (AssignmentExpressionTree)element;
                    currentState = this.store(currentState, (Tree)assignment.variable(), SymbolicValue.UNKNOWN);
                    continue;
                }
                if (element.is(new Tree.Kind[]{Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT})) {
                    UnaryExpressionTree unary = (UnaryExpressionTree)element;
                    currentState = this.store(currentState, (Tree)unary.expression(), SymbolicValue.UNKNOWN);
                    continue;
                }
                if (!element.is(new Tree.Kind[]{Tree.Kind.INITIALIZED_BINDING_ELEMENT})) continue;
                InitializedBindingElementTree initialized = (InitializedBindingElementTree)element;
                currentState = this.store(currentState, (Tree)initialized.left(), initialized.right());
            }
            this.handleSuccessors(block, currentState);
        }

        private void pushAllSuccessors(CfgBlock block, ProgramState currentState) {
            for (CfgBlock successor : block.successors()) {
                this.pushSuccessor(successor, currentState);
            }
        }

        private void pushSuccessor(CfgBlock successor, ProgramState currentState) {
            this.workList.addLast(new BlockExecution(successor, currentState));
        }

        private void handleSuccessors(CfgBlock block, ProgramState incomingState) {
            ProgramState currentState = incomingState;
            if (block instanceof CfgBranchingBlock) {
                CfgBranchingBlock branchingBlock = (CfgBranchingBlock)block;
                Tree branchingTree = branchingBlock.branchingTree();
                if (branchingTree.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT, Tree.Kind.WHILE_STATEMENT, Tree.Kind.FOR_STATEMENT, Tree.Kind.DO_WHILE_STATEMENT, Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR})) {
                    this.handleConditionSuccessors(branchingBlock, currentState);
                    return;
                }
                if (branchingTree.is(new Tree.Kind[]{Tree.Kind.FOR_IN_STATEMENT, Tree.Kind.FOR_OF_STATEMENT})) {
                    ForObjectStatementTree forTree = (ForObjectStatementTree)branchingTree;
                    Tree variable = forTree.variableOrExpression();
                    if (variable.is(new Tree.Kind[]{Tree.Kind.VAR_DECLARATION})) {
                        VariableDeclarationTree declaration = (VariableDeclarationTree)variable;
                        variable = (Tree)declaration.variables().get(0);
                    }
                    currentState = this.store(currentState, variable, SymbolicValue.UNKNOWN);
                }
            }
            this.pushAllSuccessors(block, currentState);
        }

        private void handleConditionSuccessors(CfgBranchingBlock block, ProgramState currentState) {
            Truthiness falseSuccessorTruthiness;
            Truthiness trueSuccessorTruthiness;
            Symbol conditionVariable;
            Tree lastElement = (Tree)block.elements().get(block.elements().size() - 1);
            if (lastElement.is(new Tree.Kind[]{Tree.Kind.BOOLEAN_LITERAL})) {
                SymbolicValue conditionValue = SymbolicValue.get((ExpressionTree)((LiteralTree)lastElement));
                Truthiness conditionTruthiness = conditionValue.truthiness();
                if (!block.branchingTree().is(new Tree.Kind[]{Tree.Kind.FOR_STATEMENT, Tree.Kind.WHILE_STATEMENT, Tree.Kind.DO_WHILE_STATEMENT})) {
                    this.conditionResults.put((Object)lastElement, (Object)conditionTruthiness);
                }
                CfgBlock successor = conditionTruthiness == Truthiness.TRUTHY ? block.trueSuccessor() : block.falseSuccessor();
                this.pushSuccessor(successor, currentState);
                return;
            }
            boolean isUnaryNot = lastElement.is(new Tree.Kind[]{Tree.Kind.LOGICAL_COMPLEMENT});
            if (isUnaryNot) {
                UnaryExpressionTree unary = (UnaryExpressionTree)lastElement;
                conditionVariable = this.trackedVariable((Tree)unary.expression());
                trueSuccessorTruthiness = Truthiness.FALSY;
                falseSuccessorTruthiness = Truthiness.TRUTHY;
            } else {
                conditionVariable = this.trackedVariable(lastElement);
                trueSuccessorTruthiness = Truthiness.TRUTHY;
                falseSuccessorTruthiness = Truthiness.FALSY;
            }
            if (conditionVariable != null) {
                SymbolicValue currentValue = currentState.get(conditionVariable);
                Truthiness currentTruthiness = currentValue.truthiness();
                Truthiness conditionTruthiness = isUnaryNot ? currentTruthiness.not() : currentTruthiness;
                this.conditionResults.put((Object)lastElement, (Object)conditionTruthiness);
                if (currentTruthiness != falseSuccessorTruthiness) {
                    this.pushSuccessor(block.trueSuccessor(), currentState.constrain(conditionVariable, trueSuccessorTruthiness));
                }
                if (currentTruthiness != trueSuccessorTruthiness) {
                    this.pushSuccessor(block.falseSuccessor(), currentState.constrain(conditionVariable, falseSuccessorTruthiness));
                }
            } else {
                this.pushAllSuccessors((CfgBlock)block, currentState);
            }
        }

        private ProgramState store(ProgramState currentState, Tree left, ExpressionTree right) {
            SymbolicValue symbolicValue = SymbolicValue.get((ExpressionTree)right);
            return this.store(currentState, left, symbolicValue);
        }

        private ProgramState store(ProgramState currentState, Tree left, SymbolicValue symbolicValue) {
            Symbol trackedVariable = this.trackedVariable(left);
            if (trackedVariable != null) {
                return currentState.copyAndAddValue(trackedVariable, symbolicValue);
            }
            return currentState;
        }

        @CheckForNull
        private Symbol trackedVariable(Tree tree) {
            if (tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE, Tree.Kind.BINDING_IDENTIFIER})) {
                IdentifierTree identifier = (IdentifierTree)tree;
                Symbol symbol = identifier.symbol();
                return this.trackedVariables.contains(symbol) ? symbol : null;
            }
            return null;
        }
    }
}

