/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2688", name="\"NaN\" should not be used in comparisons", priority=Priority.BLOCKER, tags={"bug"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class ComparisonWithNaNCheck
extends SubscriptionVisitorCheck {
    private static final String MESSAGE = "Use a test of the format \"a %s a\" instead.";

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.EQUAL_TO, (Object)Tree.Kind.NOT_EQUAL_TO, (Object)Tree.Kind.STRICT_EQUAL_TO, (Object)Tree.Kind.STRICT_NOT_EQUAL_TO);
    }

    public void visitNode(Tree tree) {
        BinaryExpressionTree equalityExpr = (BinaryExpressionTree)tree;
        if (ComparisonWithNaNCheck.isNaN(equalityExpr.leftOperand()) || ComparisonWithNaNCheck.isNaN(equalityExpr.rightOperand())) {
            this.addLineIssue(tree, String.format(MESSAGE, equalityExpr.operator().text()));
        }
    }

    private static boolean isNaN(ExpressionTree expression) {
        return expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE}) && "NaN".equals(((IdentifierTree)expression).name());
    }
}

