/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionTree;
import org.sonar.plugins.javascript.api.tree.declaration.InitializedBindingElementTree;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1788", name="Function parameters with default values should be last", priority=Priority.CRITICAL, tags={"es2015", "bug"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="20min")
public class DefaultParametersNotLastCheck
extends SubscriptionVisitorCheck {
    private static final String MESSAGE = "Move parameter%s \"%s\" after parameters without default value.";

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.FUNCTION_DECLARATION, (Object)Tree.Kind.GENERATOR_METHOD, (Object)Tree.Kind.GENERATOR_DECLARATION, (Object)Tree.Kind.GENERATOR_FUNCTION_EXPRESSION, (Object)Tree.Kind.FUNCTION_EXPRESSION, (Object)Tree.Kind.ARROW_FUNCTION, (Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        List parameterList = ((FunctionTree)tree).parameterList();
        ArrayList<InitializedBindingElementTree> parametersWithDefault = new ArrayList<InitializedBindingElementTree>();
        boolean raiseIssue = false;
        for (Tree parameter : parameterList) {
            if (parameter.is(new Tree.Kind[]{Tree.Kind.INITIALIZED_BINDING_ELEMENT})) {
                parametersWithDefault.add((InitializedBindingElementTree)parameter);
                continue;
            }
            if (parametersWithDefault.isEmpty()) continue;
            raiseIssue = true;
        }
        if (raiseIssue) {
            this.raiseIssue(parametersWithDefault);
        }
    }

    private void raiseIssue(List<InitializedBindingElementTree> parametersWithDefault) {
        StringBuilder sb = new StringBuilder();
        for (InitializedBindingElementTree parameter : parametersWithDefault) {
            sb.append(CheckUtils.asString((Tree)parameter.left()));
            sb.append("\", \"");
        }
        String parameters = sb.toString();
        parameters = parameters.substring(0, parameters.length() - 4);
        String plural = parametersWithDefault.size() == 1 ? "" : "s";
        PreciseIssue preciseIssue = this.addIssue((Tree)parametersWithDefault.get(0).left(), String.format(MESSAGE, plural, parameters));
        for (int i = 1; i < parametersWithDefault.size(); ++i) {
            preciseIssue.secondary((Tree)parametersWithDefault.get(i).left());
        }
    }
}

