/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.AbstractJQuerySelectorOptimizationCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2714", name="Element type selectors should not be used with class selectors", priority=Priority.MAJOR, tags={"jquery", "performance", "user-experience"})
@SqaleSubCharacteristic(value="CPU_EFFICIENCY")
@SqaleConstantRemediation(value="2min")
public class ElementUsedWithClassSelectorCheck
extends AbstractJQuerySelectorOptimizationCheck {
    private static final String MESSAGE = "Remove \"%s\" in this selector.";
    private static final Pattern elementUsedWithClassSelectorPattern = Pattern.compile("(\\w+)\\.([\\w_-]+)");

    @Override
    protected void visitSelector(String selector, CallExpressionTree tree) {
        Matcher matcher = elementUsedWithClassSelectorPattern.matcher(selector);
        if (tree.arguments().parameters().size() == 1 && matcher.matches()) {
            this.addLineIssue((Tree)tree, String.format(MESSAGE, matcher.group(1)));
        }
    }
}

