/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.SymbolModel;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="UnusedFunctionArgument", name="Unused function parameters should be removed", priority=Priority.MAJOR, tags={"misra", "unused"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class UnusedFunctionArgumentCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Remove the unused function parameter%s \"%s\".";

    public Collection<Scope> getScopes() {
        SymbolModel symbolModel = this.getContext().getSymbolModel();
        HashSet<Scope> uniqueScopes = new HashSet<Scope>();
        for (Symbol symbol : symbolModel.getSymbols()) {
            uniqueScopes.add(symbol.scope());
        }
        return uniqueScopes;
    }

    public void visitScript(ScriptTree tree) {
        Collection<Scope> scopes = this.getScopes();
        for (Scope scope : scopes) {
            this.visitScope(scope);
        }
    }

    private void visitScope(Scope scope) {
        if (UnusedFunctionArgumentCheck.builtInArgumentsUsed(scope) || scope.tree().is(new Tree.Kind[]{Tree.Kind.SET_METHOD})) {
            return;
        }
        List arguments = scope.getSymbols(Symbol.Kind.PARAMETER);
        List<Symbol> unusedArguments = UnusedFunctionArgumentCheck.getUnusedArguments(arguments);
        if (!unusedArguments.isEmpty()) {
            String ending = unusedArguments.size() == 1 ? "" : "s";
            this.addLineIssue(scope.tree(), String.format(MESSAGE, ending, UnusedFunctionArgumentCheck.getListOfArguments(unusedArguments)));
        }
    }

    private static List<Symbol> getUnusedArguments(List<Symbol> arguments) {
        LinkedList<Symbol> unusedArguments = new LinkedList<Symbol>();
        Collections.sort(arguments, new PositionComparator());
        List<Boolean> usageInfo = UnusedFunctionArgumentCheck.getUsageInfo(arguments);
        boolean usedAfter = false;
        for (int i = arguments.size() - 1; i >= 0; --i) {
            if (usageInfo.get(i).booleanValue()) {
                usedAfter = true;
                continue;
            }
            if (usedAfter) continue;
            unusedArguments.add(0, arguments.get(i));
        }
        return unusedArguments;
    }

    private static boolean builtInArgumentsUsed(Scope scope) {
        Symbol argumentsBuiltInVariable = scope.lookupSymbol("arguments");
        if (argumentsBuiltInVariable == null) {
            return false;
        }
        boolean isUsed = !argumentsBuiltInVariable.usages().isEmpty();
        return argumentsBuiltInVariable.builtIn() && isUsed;
    }

    private static List<Boolean> getUsageInfo(List<Symbol> symbols) {
        LinkedList<Boolean> result = new LinkedList<Boolean>();
        for (Symbol symbol : symbols) {
            if (symbol.usages().size() == 1) {
                result.add(false);
                continue;
            }
            result.add(true);
        }
        return result;
    }

    private static String getListOfArguments(List<Symbol> unusedArguments) {
        StringBuilder result = new StringBuilder();
        for (Symbol symbol : unusedArguments) {
            result.append(symbol.name());
            result.append(", ");
        }
        return result.toString().replaceFirst(", $", "");
    }

    private static class PositionComparator
    implements Comparator<Symbol> {
        private PositionComparator() {
        }

        private static int getLine(Symbol symbol) {
            return ((JavaScriptTree)PositionComparator.getDeclarationUsage(symbol).identifierTree()).getLine();
        }

        private static int getColumn(Symbol symbol) {
            return ((JavaScriptTree)PositionComparator.getDeclarationUsage(symbol).identifierTree()).getFirstToken().column();
        }

        @Override
        public int compare(Symbol symbol1, Symbol symbol2) {
            int lineCompare = Integer.compare(PositionComparator.getLine(symbol1), PositionComparator.getLine(symbol2));
            if (lineCompare == 0) {
                return Integer.compare(PositionComparator.getColumn(symbol1), PositionComparator.getColumn(symbol2));
            }
            return lineCompare;
        }

        private static Usage getDeclarationUsage(Symbol symbol) {
            Preconditions.checkArgument((boolean)symbol.is(Symbol.Kind.PARAMETER));
            for (Usage usage : symbol.usages()) {
                if (usage.kind() != Usage.Kind.LEXICAL_DECLARATION) continue;
                return usage;
            }
            throw new IllegalStateException();
        }
    }
}

