/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se;

import java.util.Objects;
import org.sonar.javascript.se.Truthiness;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;

public class SymbolicValue {
    public static final SymbolicValue NULL_OR_UNDEFINED = new SymbolicValue(true, Truthiness.FALSY);
    public static final SymbolicValue UNKNOWN = new SymbolicValue(false, Truthiness.UNKNOWN);
    private static final SymbolicValue TRUTHY = new SymbolicValue(false, Truthiness.TRUTHY);
    private static final SymbolicValue FALSY = new SymbolicValue(false, Truthiness.FALSY);
    private final boolean definitelyNullOrUndefined;
    private final Truthiness truthiness;

    private SymbolicValue(boolean alwaysNullOrUndefined, Truthiness truthiness) {
        this.definitelyNullOrUndefined = alwaysNullOrUndefined;
        this.truthiness = truthiness;
    }

    public static SymbolicValue get(ExpressionTree expression) {
        IdentifierTree identifier;
        SymbolicValue value = UNKNOWN;
        if (expression.is(Tree.Kind.NULL_LITERAL)) {
            value = NULL_OR_UNDEFINED;
        } else if (expression.is(Tree.Kind.BOOLEAN_LITERAL)) {
            value = SymbolicValue.booleanLiteral((LiteralTree)expression);
        } else if (expression.is(Tree.Kind.STRING_LITERAL)) {
            value = SymbolicValue.stringLiteral((LiteralTree)expression);
        } else if (expression.is(Tree.Kind.NUMERIC_LITERAL)) {
            value = SymbolicValue.numericLiteral((LiteralTree)expression);
        } else if (expression.is(Tree.Kind.IDENTIFIER_REFERENCE) && "undefined".equals((identifier = (IdentifierTree)expression).name())) {
            value = NULL_OR_UNDEFINED;
        }
        return value;
    }

    private static SymbolicValue booleanLiteral(LiteralTree expression) {
        return SymbolicValue.literal("true".equals(expression.value()));
    }

    private static SymbolicValue stringLiteral(LiteralTree expression) {
        return SymbolicValue.literal(expression.value().length() > 2);
    }

    private static SymbolicValue numericLiteral(LiteralTree expression) {
        String stringValue = expression.value();
        if (stringValue.startsWith("0x") || stringValue.startsWith("0b") || stringValue.startsWith("0o") || stringValue.startsWith("0O")) {
            return SymbolicValue.literal(SymbolicValue.hasNonZero(stringValue.substring(2)));
        }
        int exponentIndex = stringValue.indexOf(101);
        if (exponentIndex == -1) {
            exponentIndex = stringValue.indexOf(69);
        }
        if (exponentIndex > -1) {
            stringValue = stringValue.substring(0, exponentIndex);
        }
        return SymbolicValue.literal(SymbolicValue.hasNonZero(stringValue));
    }

    private static boolean hasNonZero(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '0' || c == '.') continue;
            return true;
        }
        return false;
    }

    public static SymbolicValue literal(boolean isTruthy) {
        return isTruthy ? TRUTHY : FALSY;
    }

    public boolean isDefinitelyNullOrUndefined() {
        return this.definitelyNullOrUndefined;
    }

    public Truthiness truthiness() {
        return this.truthiness;
    }

    public SymbolicValue constrain(Truthiness truthiness) {
        return new SymbolicValue(this.definitelyNullOrUndefined, truthiness);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.definitelyNullOrUndefined, this.truthiness});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SymbolicValue other = (SymbolicValue)obj;
        return this.definitelyNullOrUndefined == other.definitelyNullOrUndefined && Objects.equals((Object)this.truthiness, (Object)other.truthiness);
    }
}

