/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.impl.declaration;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.impl.declaration.ParameterListTreeImpl;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.javascript.tree.impl.statement.BlockTreeImpl;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.AccessorMethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.ParameterListTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;

public class AccessorMethodDeclarationTreeImpl
extends JavaScriptTree
implements AccessorMethodDeclarationTree {
    private final Tree.Kind kind;
    private InternalSyntaxToken staticToken;
    private final InternalSyntaxToken accessorToken;
    private final ExpressionTree name;
    private final ParameterListTreeImpl parameters;
    private final BlockTreeImpl body;

    public AccessorMethodDeclarationTreeImpl(@Nullable InternalSyntaxToken staticToken, InternalSyntaxToken accessorToken, ExpressionTree name, ParameterListTreeImpl parameters, BlockTreeImpl body) {
        this.staticToken = staticToken;
        this.kind = "get".equals(accessorToken.text()) ? Tree.Kind.GET_METHOD : Tree.Kind.SET_METHOD;
        this.accessorToken = accessorToken;
        this.name = name;
        this.parameters = parameters;
        this.body = body;
    }

    @Override
    @Nullable
    public SyntaxToken staticToken() {
        return this.staticToken;
    }

    @Override
    public InternalSyntaxToken accessorToken() {
        Preconditions.checkState((this.is(Tree.Kind.GET_METHOD) || this.is(Tree.Kind.SET_METHOD) ? 1 : 0) != 0);
        return this.accessorToken;
    }

    @Override
    public ExpressionTree name() {
        return this.name;
    }

    @Override
    public ParameterListTree parameterClause() {
        return this.parameters;
    }

    @Override
    public BlockTreeImpl body() {
        return this.body;
    }

    @Override
    public List<Tree> parameterList() {
        return this.parameters.parameters();
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.staticToken, this.accessorToken, this.name, this.parameters, this.body});
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitMethodDeclaration(this);
    }
}

