/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.api.visitors;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.visitors.TreeVisitor;
import org.sonar.plugins.javascript.api.visitors.TreeVisitorContext;

public abstract class SubscriptionVisitor
implements TreeVisitor {
    private TreeVisitorContext context;
    private Collection<Tree.Kind> nodesToVisit;

    public abstract List<Tree.Kind> nodesToVisit();

    public void visitNode(Tree tree) {
    }

    public void leaveNode(Tree tree) {
    }

    public void visitFile(Tree scriptTree) {
    }

    public void leaveFile(Tree scriptTree) {
    }

    @Override
    public TreeVisitorContext getContext() {
        Preconditions.checkState((this.context != null ? 1 : 0) != 0, (Object)"this#scanTree(context) should be called to initialised the context before accessing it");
        return this.context;
    }

    @Override
    public final void scanTree(TreeVisitorContext context) {
        this.context = context;
        this.visitFile(context.getTopTree());
        this.scanTree(context.getTopTree());
        this.leaveFile(context.getTopTree());
    }

    public void scanTree(Tree tree) {
        this.nodesToVisit = this.nodesToVisit();
        this.visit(tree);
    }

    private void visit(Tree tree) {
        boolean isSubscribed = this.isSubscribed(tree);
        if (isSubscribed) {
            this.visitNode(tree);
        }
        this.visitChildren(tree);
        if (isSubscribed) {
            this.leaveNode(tree);
        }
    }

    protected boolean isSubscribed(Tree tree) {
        return this.nodesToVisit.contains((Object)((JavaScriptTree)tree).getKind());
    }

    private void visitChildren(Tree tree) {
        JavaScriptTree javaTree = (JavaScriptTree)tree;
        if (!javaTree.isLeaf()) {
            Iterator<Tree> iter = javaTree.childrenIterator();
            while (iter.hasNext()) {
                Tree next = iter.next();
                if (next == null) continue;
                this.visit(next);
            }
        }
    }
}

