/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.metrics;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitor;

public class LineVisitor
extends SubscriptionVisitor {
    private Set<Integer> lines = Sets.newHashSet();
    private int lastLine = 0;

    public LineVisitor(Tree tree) {
        this.scanTree(tree);
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)((Object)Tree.Kind.TOKEN));
    }

    @Override
    public void visitNode(Tree tree) {
        SyntaxToken token = (SyntaxToken)tree;
        if (!((InternalSyntaxToken)token).isEOF()) {
            this.lines.add(token.line());
        } else {
            this.lastLine = token.line();
        }
    }

    public int getLinesOfCodeNumber() {
        return this.lines.size();
    }

    public Set<Integer> getLinesOfCode() {
        return this.lines;
    }

    public int getLinesNumber() {
        return this.lastLine;
    }
}

