/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.impl.declaration;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.impl.SeparatedList;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.BindingElementTree;
import org.sonar.plugins.javascript.api.tree.declaration.ObjectBindingPatternTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;

public class ObjectBindingPatternTreeImpl
extends JavaScriptTree
implements ObjectBindingPatternTree {
    private SyntaxToken openCurlyBrace;
    private SeparatedList<BindingElementTree> bindingElements;
    private SyntaxToken closeCurlyBrace;

    public ObjectBindingPatternTreeImpl(SyntaxToken openCurlyBrace, SeparatedList<BindingElementTree> bindingElements, SyntaxToken closeCurlyBrace) {
        this.openCurlyBrace = openCurlyBrace;
        this.bindingElements = bindingElements;
        this.closeCurlyBrace = closeCurlyBrace;
    }

    @Override
    public SyntaxToken openCurlyBrace() {
        return this.openCurlyBrace;
    }

    @Override
    public SeparatedList<BindingElementTree> elements() {
        return this.bindingElements;
    }

    @Override
    public SyntaxToken closeCurlyBrace() {
        return this.closeCurlyBrace;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.OBJECT_BINDING_PATTERN;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat((Iterator)Iterators.singletonIterator((Object)this.openCurlyBrace), this.bindingElements.elementsAndSeparators((Function<BindingElementTree, Tree>)Functions.identity()), (Iterator)Iterators.singletonIterator((Object)this.closeCurlyBrace));
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitObjectBindingPattern(this);
    }

    @Override
    public List<IdentifierTree> bindingIdentifiers() {
        ArrayList bindingIdentifiers = Lists.newArrayList();
        for (BindingElementTree element : this.bindingElements) {
            bindingIdentifiers.addAll(element.bindingIdentifiers());
        }
        return bindingIdentifiers;
    }
}

