/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript;

import com.google.common.base.Preconditions;
import java.io.File;
import org.sonar.api.config.Settings;
import org.sonar.api.issue.Issuable;
import org.sonar.api.rule.RuleKey;
import org.sonar.javascript.metrics.ComplexityVisitor;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.plugins.javascript.JavaScriptChecks;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.symbols.SymbolModel;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.visitors.TreeVisitorContext;

public class JavaScriptCheckContext
implements TreeVisitorContext {
    private final ScriptTree tree;
    private final File file;
    private final SymbolModel symbolModel;
    private final Settings settings;
    private final ComplexityVisitor complexity;
    private final Issuable issuable;
    private final JavaScriptChecks checks;

    public JavaScriptCheckContext(ScriptTree tree, Issuable issuable, File file, SymbolModel symbolModel, Settings settings, JavaScriptChecks checks, ComplexityVisitor complexityVisitor) {
        this.tree = tree;
        this.file = file;
        this.symbolModel = symbolModel;
        this.settings = settings;
        this.complexity = complexityVisitor;
        this.issuable = issuable;
        this.checks = checks;
    }

    public ScriptTree getTopTree() {
        return this.tree;
    }

    public void addIssue(JavaScriptCheck check, Tree tree, String message) {
        this.commonAddIssue(check, JavaScriptCheckContext.getLine(tree), message, -1.0);
    }

    public void addIssue(JavaScriptCheck check, int line, String message) {
        this.commonAddIssue(check, line, message, -1.0);
    }

    public void addFileIssue(JavaScriptCheck check, String message) {
        this.commonAddIssue(check, -1, message, -1.0);
    }

    public void addIssue(JavaScriptCheck check, Tree tree, String message, double cost) {
        this.commonAddIssue(check, JavaScriptCheckContext.getLine(tree), message, cost);
    }

    public void addIssue(JavaScriptCheck check, int line, String message, double cost) {
        this.commonAddIssue(check, line, message, cost);
    }

    public File getFile() {
        return this.file;
    }

    private void commonAddIssue(JavaScriptCheck check, int line, String message, double cost) {
        Preconditions.checkNotNull((Object)check);
        Preconditions.checkNotNull((Object)message);
        RuleKey ruleKey = this.checks.ruleKeyFor(check);
        if (ruleKey == null) {
            throw new IllegalStateException("No rule key found for a rule");
        }
        Issuable.IssueBuilder issueBuilder = this.issuable.newIssueBuilder().ruleKey(ruleKey).message(message);
        if (line > 0) {
            issueBuilder.line(Integer.valueOf(line));
        }
        if (cost > 0.0) {
            issueBuilder.effortToFix(Double.valueOf(cost));
        }
        this.issuable.addIssue(issueBuilder.build());
    }

    private static int getLine(Tree tree) {
        return ((JavaScriptTree)tree).getLine();
    }

    public SymbolModel getSymbolModel() {
        return this.symbolModel;
    }

    public String[] getPropertyValues(String name) {
        return this.settings.getStringArray(name);
    }

    public int getComplexity(Tree tree) {
        return this.complexity.getComplexity(tree);
    }
}

