/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.StringElement;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Trivia;
import org.sonar.python.checks.Expressions;
import org.sonar.python.parser.PythonParser;
import org.sonar.python.tree.PythonTreeMaker;

@Rule(key="S125")
public class CommentedCodeCheck
extends PythonSubscriptionCheck {
    public static final String MESSAGE = "Remove this commented out code.";
    private static final Pattern ENCODING_PATTERN = Pattern.compile(".*?coding[:=][ \\t]*([-_.a-zA-Z0-9]+)\n");
    private static final PythonParser parser = PythonParser.create();

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.TOKEN, ctx -> {
            Token token = (Token)ctx.syntaxNode();
            List<List<Trivia>> groupedTrivias = CommentedCodeCheck.groupTrivias(token);
            for (List<Trivia> triviaGroup : groupedTrivias) {
                CommentedCodeCheck.checkTriviaGroup(triviaGroup, ctx);
            }
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.STRING_LITERAL, ctx -> {
            StringLiteral stringLiteral = (StringLiteral)ctx.syntaxNode();
            if (CommentedCodeCheck.isMultilineComment(stringLiteral)) {
                CommentedCodeCheck.visitMultilineComment(stringLiteral, ctx);
            }
        });
    }

    private static boolean isMultilineComment(StringLiteral stringLiteral) {
        Tree parent = stringLiteral.parent();
        StringElement firstElement = (StringElement)stringLiteral.stringElements().get(0);
        return firstElement.isTripleQuoted() && parent.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STMT});
    }

    private static void visitMultilineComment(StringLiteral stringLiteral, SubscriptionContext ctx) {
        String text = Expressions.unescape(stringLiteral);
        if (!CommentedCodeCheck.isEmpty(text = text.trim()) && CommentedCodeCheck.isTextParsedAsCode(text)) {
            ctx.addIssue((Tree)stringLiteral, MESSAGE);
        }
    }

    private static void checkTriviaGroup(List<Trivia> triviaGroup, SubscriptionContext ctx) {
        String text = CommentedCodeCheck.getTextForParsing(triviaGroup);
        if (CommentedCodeCheck.isEmpty(text)) {
            return;
        }
        if (CommentedCodeCheck.isTextParsedAsCode(text) && !CommentedCodeCheck.isEncoding(triviaGroup.get(0).token().line(), text)) {
            ctx.addIssue(triviaGroup.get(0).token(), MESSAGE);
        }
    }

    private static String getTextForParsing(List<Trivia> triviaGroup) {
        StringBuilder commentTextSB = new StringBuilder();
        for (Trivia trivia : triviaGroup) {
            String value = trivia.value();
            while (value.startsWith("#") || value.startsWith(" #")) {
                value = value.substring(1);
            }
            if (value.startsWith(" ")) {
                value = value.substring(1);
            }
            if (triviaGroup.size() == 1) {
                value = value.trim();
            }
            if (CommentedCodeCheck.isOneWord(value)) continue;
            commentTextSB.append(value);
            commentTextSB.append("\n");
        }
        return commentTextSB.toString();
    }

    private static boolean isOneWord(String text) {
        return text.matches("\\s*[\\w/\\-]+\\s*#*\n*");
    }

    private static boolean isEmpty(String text) {
        return text.matches("\\s*");
    }

    private static boolean isEncoding(int line, String text) {
        return line < 3 && ENCODING_PATTERN.matcher(text).matches();
    }

    private static boolean isTextParsedAsCode(String text) {
        try {
            AstNode astNode = parser.parse(text);
            FileInput parse = new PythonTreeMaker().fileInput(astNode);
            return parse.statements() != null && !CommentedCodeCheck.isSimpleExpression(parse);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isSimpleExpression(FileInput fileInput) {
        if (fileInput.statements().statements().size() > 1) {
            return false;
        }
        Statement statement = (Statement)fileInput.statements().statements().get(0);
        return statement.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STMT}) || statement.is(new Tree.Kind[]{Tree.Kind.ANNOTATED_ASSIGNMENT});
    }

    private static List<List<Trivia>> groupTrivias(Token token) {
        ArrayList<List<Trivia>> result = new ArrayList<List<Trivia>>();
        List<Trivia> currentGroup = null;
        for (Trivia trivia : token.trivia()) {
            currentGroup = CommentedCodeCheck.handleOneLineComment(result, currentGroup, trivia);
        }
        if (currentGroup != null) {
            result.add(currentGroup);
        }
        return result;
    }

    private static List<Trivia> handleOneLineComment(List<List<Trivia>> result, @Nullable List<Trivia> currentGroup, Trivia trivia) {
        List<Trivia> newTriviaGroup = currentGroup;
        if (currentGroup == null) {
            newTriviaGroup = new ArrayList<Trivia>();
            newTriviaGroup.add(trivia);
        } else if (currentGroup.get(currentGroup.size() - 1).token().line() + 1 == trivia.token().line()) {
            newTriviaGroup.add(trivia);
        } else {
            result.add(currentGroup);
            newTriviaGroup = new ArrayList<Trivia>();
            newTriviaGroup.add(trivia);
        }
        return newTriviaGroup;
    }
}

