/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.ConditionalExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S3358")
public class NestedConditionalExpressionCheck
extends PythonSubscriptionCheck {
    private static final Tree.Kind[] COMPREHENSION_KINDS = new Tree.Kind[]{Tree.Kind.LIST_COMPREHENSION, Tree.Kind.DICT_COMPREHENSION, Tree.Kind.SET_COMPREHENSION, Tree.Kind.GENERATOR_EXPR};

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CONDITIONAL_EXPR, ctx -> {
            Tree conditionalExpression = ctx.syntaxNode();
            Tree parentConditional = TreeUtils.firstAncestorOfKind((Tree)conditionalExpression, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.CONDITIONAL_EXPR});
            if (parentConditional != null) {
                boolean isInsideComprehension;
                boolean bl = isInsideComprehension = TreeUtils.firstAncestorOfKind((Tree)conditionalExpression, (Tree.Kind[])COMPREHENSION_KINDS) != null;
                if (!isInsideComprehension) {
                    ctx.addIssue(conditionalExpression, "Extract this nested conditional expression into an independent statement.").secondary(((ConditionalExpression)parentConditional).ifKeyword(), null);
                }
            }
        });
    }
}

