/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.text.MessageFormat;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.Tree;

@Rule(key="S104")
public class TooManyLinesInFileCheck
extends PythonSubscriptionCheck {
    public static final String CHECK_KEY = "S104";
    private static final int DEFAULT = 1000;
    private static final String MESSAGE = "File \"{0}\" has {1} lines, which is greater than {2} authorized. Split it into smaller files.";
    @RuleProperty(key="maximum", description="Maximum authorized lines in a file", defaultValue="1000")
    public int maximum = 1000;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> {
            int line = ctx.syntaxNode().lastToken().line();
            if (line > this.maximum) {
                ctx.addFileIssue(MessageFormat.format(MESSAGE, ctx.pythonFile().fileName(), line, this.maximum));
            }
        });
    }
}

