/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.IssueLocation;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonVisitorContext;

@Rule(key="S1131")
public class TrailingWhitespaceCheck
implements PythonCheck {
    private static final String MESSAGE = "Remove the useless trailing whitespaces at the end of this line.";
    private static final Pattern TRAILING_WS = Pattern.compile("\\s$");

    public void scanFile(PythonVisitorContext ctx) {
        String[] lines = ctx.pythonFile().content().split("\r\n|\n|\r", -1);
        for (int i = 0; i < lines.length; ++i) {
            if (!TRAILING_WS.matcher(lines[i]).find()) continue;
            ctx.addIssue(new PythonCheck.PreciseIssue((PythonCheck)this, IssueLocation.atLineLevel((String)MESSAGE, (int)(i + 1))));
        }
    }
}

