/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.NumericLiteral;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;

@Rule(key="S4426")
public class StrongCryptographicKeysCheck
extends PythonSubscriptionCheck {
    private static final Pattern CRYPTOGRAPHY = Pattern.compile("cryptography.hazmat.primitives.asymmetric.(rsa|dsa|ec).generate_private_key");
    private static final Pattern CRYPTOGRAPHY_FORBIDDEN_CURVE = Pattern.compile("(SECP192R1|SECT163K1|SECT163R2)");
    private static final Pattern CRYPTO = Pattern.compile("Crypto.PublicKey.(RSA|DSA).generate");
    private static final Pattern CRYPTODOME = Pattern.compile("Cryptodome.PublicKey.(RSA|DSA).generate");

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            CallExpression callExpression = (CallExpression)ctx.syntaxNode();
            List arguments = callExpression.arguments();
            String qualifiedName = StrongCryptographicKeysCheck.getQualifiedName(callExpression);
            if (CRYPTOGRAPHY.matcher(qualifiedName).matches()) {
                new CryptographyModuleCheck().checkArguments((SubscriptionContext)ctx, arguments);
            } else if (CRYPTO.matcher(qualifiedName).matches()) {
                new CryptoModuleCheck().checkArguments((SubscriptionContext)ctx, arguments);
            } else if (CRYPTODOME.matcher(qualifiedName).matches()) {
                new CryptodomeModuleCheck().checkArguments((SubscriptionContext)ctx, arguments);
            }
        });
    }

    private static String getQualifiedName(CallExpression callExpression) {
        Symbol symbol = callExpression.calleeSymbol();
        return symbol != null && symbol.fullyQualifiedName() != null ? symbol.fullyQualifiedName() : "";
    }

    private static class CryptodomeModuleCheck
    extends CryptoAPICheck {
        private CryptodomeModuleCheck() {
        }

        @Override
        protected int getExponentArgumentPosition() {
            return 2;
        }

        @Override
        protected String getExponentKeywordName() {
            return "e";
        }

        @Override
        protected String getKeySizeKeywordName() {
            return "bits";
        }

        @Override
        protected int getKeySizeArgumentPosition() {
            return 0;
        }
    }

    private static class CryptoModuleCheck
    extends CryptoAPICheck {
        private CryptoModuleCheck() {
        }

        @Override
        protected int getExponentArgumentPosition() {
            return 3;
        }

        @Override
        protected int getKeySizeArgumentPosition() {
            return 0;
        }

        @Override
        protected String getExponentKeywordName() {
            return "e";
        }

        @Override
        protected String getKeySizeKeywordName() {
            return "bits";
        }
    }

    private static class CryptographyModuleCheck
    extends CryptoAPICheck {
        private CryptographyModuleCheck() {
        }

        @Override
        protected int getKeySizeArgumentPosition() {
            return 1;
        }

        @Override
        protected int getExponentArgumentPosition() {
            return 0;
        }

        @Override
        protected String getKeySizeKeywordName() {
            return "key_size";
        }

        @Override
        protected String getExponentKeywordName() {
            return "public_exponent";
        }
    }

    private static abstract class CryptoAPICheck {
        private static final int CURVE_ARGUMENT_POSITION = 0;

        private CryptoAPICheck() {
        }

        abstract int getKeySizeArgumentPosition();

        abstract int getExponentArgumentPosition();

        abstract String getKeySizeKeywordName();

        abstract String getExponentKeywordName();

        private boolean isNonCompliantKeySizeArgument(Argument argument, int index) {
            if (!argument.is(new Tree.Kind[]{Tree.Kind.REGULAR_ARGUMENT})) {
                return false;
            }
            RegularArgument regularArgument = (RegularArgument)argument;
            Name keyword = regularArgument.keywordArgument();
            if (keyword == null) {
                return index == this.getKeySizeArgumentPosition() && CryptoAPICheck.isLessThan2048(regularArgument.expression());
            }
            return keyword.name().equals(this.getKeySizeKeywordName()) && CryptoAPICheck.isLessThan2048(regularArgument.expression());
        }

        private boolean isNonCompliantExponentArgument(Argument argument, int index) {
            if (!argument.is(new Tree.Kind[]{Tree.Kind.REGULAR_ARGUMENT})) {
                return false;
            }
            RegularArgument regularArgument = (RegularArgument)argument;
            Name keyword = regularArgument.keywordArgument();
            if (keyword == null) {
                return index == this.getExponentArgumentPosition() && CryptoAPICheck.isLessThan65537(regularArgument.expression());
            }
            return keyword.name().equals(this.getExponentKeywordName()) && CryptoAPICheck.isLessThan65537(regularArgument.expression());
        }

        private static boolean isLessThan2048(Expression expression) {
            try {
                return expression.is(new Tree.Kind[]{Tree.Kind.NUMERIC_LITERAL}) && ((NumericLiteral)expression).valueAsLong() < 2048L;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }

        private static boolean isLessThan65537(Expression expression) {
            try {
                return expression.is(new Tree.Kind[]{Tree.Kind.NUMERIC_LITERAL}) && ((NumericLiteral)expression).valueAsLong() < 65537L;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }

        private static boolean isNonCompliantCurveArgument(Argument argument, int index) {
            if (!argument.is(new Tree.Kind[]{Tree.Kind.REGULAR_ARGUMENT})) {
                return false;
            }
            RegularArgument regularArgument = (RegularArgument)argument;
            Name keyword = regularArgument.keywordArgument();
            if (keyword == null) {
                return index == 0 && CryptoAPICheck.isNonCompliantCurve(regularArgument.expression());
            }
            return keyword.name().equals("curve") && CryptoAPICheck.isNonCompliantCurve(regularArgument.expression());
        }

        private static boolean isNonCompliantCurve(Expression expression) {
            if (!expression.is(new Tree.Kind[]{Tree.Kind.QUALIFIED_EXPR})) {
                return false;
            }
            QualifiedExpression qualifiedExpressionTree = (QualifiedExpression)expression;
            if (qualifiedExpressionTree.qualifier() instanceof HasSymbol) {
                Symbol symbol = ((HasSymbol)qualifiedExpressionTree.qualifier()).symbol();
                if (symbol == null || !"cryptography.hazmat.primitives.asymmetric.ec".equals(symbol.fullyQualifiedName())) {
                    return false;
                }
                return CRYPTOGRAPHY_FORBIDDEN_CURVE.matcher(qualifiedExpressionTree.name().name()).matches();
            }
            return false;
        }

        void checkArguments(SubscriptionContext ctx, List<Argument> arguments) {
            int index = 0;
            for (Argument argument : arguments) {
                if (this.isNonCompliantKeySizeArgument(argument, index)) {
                    ctx.addIssue((Tree)argument, "Use a key length of at least 2048 bits.");
                }
                if (this.isNonCompliantExponentArgument(argument, index)) {
                    ctx.addIssue((Tree)argument, "Use a public key exponent of at least 65537.");
                }
                if (!(this instanceof CryptographyModuleCheck) || !CryptoAPICheck.isNonCompliantCurveArgument(argument, index)) continue;
                ctx.addIssue((Tree)argument, "Use a key length of at least 224 bits.");
            }
        }
    }
}

