/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.SubscriptionBaseVisitor;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.IfStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.IterationStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.StatementTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="CurlyBraces", name="Control structures should always use curly braces", priority=Priority.MAJOR, tags={"cert", "cwe", "misra", "pitfall"})
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="2min")
public class AlwaysUseCurlyBracesCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.builder().add((Object)Tree.Kind.IF_STATEMENT).add((Object)Tree.Kind.ELSE_CLAUSE).add((Object)Tree.Kind.FOR_IN_STATEMENT).add((Object)Tree.Kind.FOR_STATEMENT).add((Object)Tree.Kind.WHILE_STATEMENT).add((Object)Tree.Kind.DO_WHILE_STATEMENT).build();
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.ELSE_CLAUSE})) {
            this.visitElseClause(tree);
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
            this.checkAreCurlyBracesUsed(((IfStatementTree)tree).statement(), tree);
        } else {
            this.checkAreCurlyBracesUsed(((IterationStatementTree)tree).statement(), tree);
        }
    }

    private void visitElseClause(Tree tree) {
        if (!((ElseClauseTree)tree).statement().is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
            this.checkAreCurlyBracesUsed(((ElseClauseTree)tree).statement(), tree);
        }
    }

    private void checkAreCurlyBracesUsed(StatementTree statement, Tree tree) {
        if (!statement.is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            this.getContext().addIssue((JavaScriptCheck)this, tree, "Missing curly brace.");
        }
    }
}

