/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.IfStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.StatementTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="CollapsibleIfStatements", name="Collapsible \"if\" statements should be merged", priority=Priority.MAJOR, tags={"clumsy"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="5min")
public class CollapsibleIfStatementsCheck
extends BaseTreeVisitor {
    public void visitIfStatement(IfStatementTree tree) {
        StatementTree innerStatement;
        if (tree.elseClause() == null && (this.isBlockAndContainsOnlyOneIfStatement(innerStatement = tree.statement()) || CollapsibleIfStatementsCheck.isIfStatementWithoutElse(innerStatement))) {
            this.getContext().addIssue((JavaScriptCheck)this, (Tree)tree, "Merge this if statement with the nested one.");
        }
        super.visitIfStatement(tree);
    }

    private boolean isBlockAndContainsOnlyOneIfStatement(StatementTree statement) {
        if (!statement.is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            return false;
        }
        BlockTree block = (BlockTree)statement;
        return block.statements().size() == 1 && CollapsibleIfStatementsCheck.isIfStatementWithoutElse((StatementTree)block.statements().get(0));
    }

    private static boolean isIfStatementWithoutElse(StatementTree statement) {
        return statement.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT}) && ((IfStatementTree)statement).elseClause() == null;
    }
}

