/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.ast.resolve.type.ObjectType;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.DotMemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.MemberExpressionTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2770", name="Deprecated jQuery methods should not be used", priority=Priority.MAJOR, tags={"jquery", "obsolete"})
@SqaleSubCharacteristic(value="SOFTWARE_RELATED_PORTABILITY")
@SqaleConstantRemediation(value="20min")
public class DeprecatedJQueryAPICheck
extends BaseTreeVisitor {
    private static final String MESSAGE = "Remove this use of \"%s\", which is deprecated.";
    private static final List<String> JQUERY_PROPERTIES = ImmutableList.of((Object)"boxModel", (Object)"browser", (Object)"support");
    private static final List<String> JQUERY_METHODS = ImmutableList.of((Object)"sub");
    private static final List<String> SELECTOR_PROPERTIES = ImmutableList.of((Object)"context", (Object)"afterSelector");
    private static final List<String> SELECTOR_METHODS = ImmutableList.of((Object)"andSelf", (Object)"die", (Object)"error", (Object)"live", (Object)"load", (Object)"size", (Object)"unload");

    public void visitCallExpression(CallExpressionTree tree) {
        String parentheses = "()";
        this.checkSelectorProperty(tree.callee(), SELECTOR_METHODS, parentheses);
        this.checkJQueryProperty(tree.callee(), JQUERY_METHODS, parentheses);
        super.visitCallExpression(tree);
    }

    public void visitMemberExpression(MemberExpressionTree tree) {
        String parentheses = "";
        this.checkSelectorProperty((ExpressionTree)tree, SELECTOR_PROPERTIES, parentheses);
        this.checkJQueryProperty((ExpressionTree)tree, JQUERY_PROPERTIES, parentheses);
        super.visitMemberExpression(tree);
    }

    private void checkJQueryProperty(ExpressionTree expressionTree, List<String> deprecated, String parentheses) {
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.DOT_MEMBER_EXPRESSION})) {
            ExpressionTree object = ((DotMemberExpressionTree)expressionTree).object();
            IdentifierTree property = ((DotMemberExpressionTree)expressionTree).property();
            if (object.types().contains((Object)ObjectType.FrameworkType.JQUERY_OBJECT) && DeprecatedJQueryAPICheck.propertyIsDeprecated((ExpressionTree)property, deprecated)) {
                this.getContext().addIssue((JavaScriptCheck)this, (Tree)property, String.format(MESSAGE, property.name() + parentheses));
            }
        }
    }

    private void checkSelectorProperty(ExpressionTree expressionTree, List<String> deprecated, String parentheses) {
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.DOT_MEMBER_EXPRESSION})) {
            ExpressionTree object = ((DotMemberExpressionTree)expressionTree).object();
            IdentifierTree property = ((DotMemberExpressionTree)expressionTree).property();
            if (object.types().contains((Object)ObjectType.FrameworkType.JQUERY_SELECTOR_OBJECT) && DeprecatedJQueryAPICheck.propertyIsDeprecated((ExpressionTree)property, deprecated)) {
                this.getContext().addIssue((JavaScriptCheck)this, (Tree)property, String.format(MESSAGE, property.name() + parentheses));
            }
        }
    }

    private static boolean propertyIsDeprecated(ExpressionTree property, List<String> deprecated) {
        if (property.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_NAME})) {
            IdentifierTree identifier = (IdentifierTree)property;
            return deprecated.contains(identifier.name());
        }
        return false;
    }
}

