/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.ast.visitors.SyntacticEquivalence;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.CaseClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.IfStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1862", name="Related \"if/else if\" statements and \"cases\" in a \"switch\" should not have the same condition", priority=Priority.CRITICAL, tags={"bug", "cert", "pitfall", "unused"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="10min")
public class DuplicateConditionIfElseAndSwitchCasesCheck
extends BaseTreeVisitor {
    public void visitIfStatement(IfStatementTree tree) {
        ExpressionTree condition = tree.condition();
        ElseClauseTree elseClause = tree.elseClause();
        while (elseClause != null && elseClause.statement().is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
            IfStatementTree ifStatement = (IfStatementTree)elseClause.statement();
            if (SyntacticEquivalence.areEquivalent((Tree)condition, (Tree)ifStatement.condition())) {
                this.getContext().addIssue((JavaScriptCheck)this, (Tree)ifStatement.condition(), "This branch duplicates the one on line " + ((AstNode)condition).getTokenLine() + ".");
            }
            elseClause = ifStatement.elseClause();
        }
        super.visitIfStatement(tree);
    }

    public void visitSwitchStatement(SwitchStatementTree tree) {
        for (int i = 0; i < tree.cases().size(); ++i) {
            for (int j = i + 1; j < tree.cases().size(); ++j) {
                ExpressionTree conditionToCompare;
                ExpressionTree condition = DuplicateConditionIfElseAndSwitchCasesCheck.getCondition((SwitchClauseTree)tree.cases().get(i));
                if (!SyntacticEquivalence.areEquivalent((Tree)condition, (Tree)(conditionToCompare = DuplicateConditionIfElseAndSwitchCasesCheck.getCondition((SwitchClauseTree)tree.cases().get(j))))) continue;
                this.getContext().addIssue((JavaScriptCheck)this, (Tree)conditionToCompare, "This case duplicates the one on line " + ((AstNode)condition).getTokenLine() + ".");
            }
        }
    }

    @Nullable
    private static ExpressionTree getCondition(SwitchClauseTree clause) {
        return clause.is(new Tree.Kind[]{Tree.Kind.CASE_CLAUSE}) ? ((CaseClauseTree)clause).expression() : null;
    }
}

