/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="EmptyBlock", name="Nested blocks of code should not be left empty", priority=Priority.MAJOR, tags={"bug"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class EmptyBlockCheck
extends BaseTreeVisitor {
    public void visitBlock(BlockTree tree) {
        if (tree.statements().isEmpty() && !EmptyBlockCheck.hasComment(tree.closeCurlyBrace())) {
            this.getContext().addIssue((JavaScriptCheck)this, (Tree)tree, "Either remove or fill this block of code.");
        }
        super.visitBlock(tree);
    }

    public void visitFunctionExpression(FunctionExpressionTree tree) {
        this.scan((Tree)tree.name());
        this.scan((Tree)tree.parameters());
        this.scan(tree.body().statements());
    }

    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        this.scan((Tree)tree.name());
        this.scan((Tree)tree.parameters());
        this.scan(tree.body().statements());
    }

    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.scan((Tree)tree.name());
        this.scan((Tree)tree.parameters());
        this.scan(tree.body().statements());
    }

    private static boolean hasComment(SyntaxToken closingBrace) {
        return !closingBrace.trivias().isEmpty();
    }
}

