/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.BindingElementTree;
import org.sonar.plugins.javascript.api.tree.declaration.InitializedBindingElementTree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.tree.statement.ForStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.VariableDeclarationTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S888", name="Relational operators should be used in \"for\" loop termination conditions", priority=Priority.CRITICAL, tags={"bug", "cert", "cwe", "misra"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="2min")
public class EqualInForLoopTerminationCheck
extends BaseTreeVisitor {
    public void visitForStatement(ForStatementTree tree) {
        boolean updateCondition;
        ExpressionTree condition = tree.condition();
        ExpressionTree update = tree.update();
        boolean conditionCondition = condition != null && EqualInForLoopTerminationCheck.isEquality(condition);
        boolean bl = updateCondition = update != null && this.isUpdateIncDec(update);
        if (conditionCondition && updateCondition && (condition.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO}) || !this.isException(tree))) {
            this.addIssue(condition);
        }
        super.visitForStatement(tree);
    }

    private void addIssue(ExpressionTree condition) {
        String message = String.format("Replace '%s' operator with one of '<=', '>=', '<', or '>' comparison operators.", ((BinaryExpressionTree)condition).operator().text());
        this.getContext().addIssue((JavaScriptCheck)this, (Tree)condition, message);
    }

    private static boolean isEquality(ExpressionTree condition) {
        return condition.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO});
    }

    private boolean isException(ForStatementTree forStatement) {
        return EqualInForLoopTerminationCheck.isNullConditionException(forStatement) || this.isTrivialIteratorException(forStatement);
    }

    private boolean isTrivialIteratorException(ForStatementTree forStatement) {
        ExpressionTree condition = forStatement.condition();
        if (condition != null && condition.is(new Tree.Kind[]{Tree.Kind.NOT_EQUAL_TO})) {
            ExpressionTree update = forStatement.update();
            Tree init = forStatement.init();
            if (init != null && update != null) {
                return this.checkForTrivialIteratorException(init, condition, update);
            }
        }
        return false;
    }

    private boolean checkForTrivialIteratorException(Tree init, ExpressionTree condition, ExpressionTree update) {
        int updateByOne = this.checkForUpdateByOne(update);
        if (updateByOne != 0) {
            Integer endValue = this.getValue((Tree)condition);
            Integer beginValue = this.getValue(init);
            if (endValue != null && beginValue != null && updateByOne == Integer.signum(endValue - beginValue)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isNullConditionException(ForStatementTree forStatement) {
        ExpressionTree condition = forStatement.condition();
        return condition != null && condition.is(new Tree.Kind[]{Tree.Kind.NOT_EQUAL_TO}) && ((BinaryExpressionTree)condition).rightOperand().is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL});
    }

    private Integer getValue(Tree tree) {
        Integer result = null;
        if (tree.is(new Tree.Kind[]{Tree.Kind.NOT_EQUAL_TO})) {
            result = EqualInForLoopTerminationCheck.getInteger(((BinaryExpressionTree)tree).rightOperand());
        } else if (EqualInForLoopTerminationCheck.isOneVarDeclaration(tree)) {
            BindingElementTree variable = (BindingElementTree)((VariableDeclarationTree)tree).variables().get(0);
            if (variable.is(new Tree.Kind[]{Tree.Kind.INITIALIZED_BINDING_ELEMENT})) {
                result = EqualInForLoopTerminationCheck.getInteger(((InitializedBindingElementTree)variable).right());
            }
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
            result = EqualInForLoopTerminationCheck.getInteger(((AssignmentExpressionTree)tree).expression());
        }
        return result;
    }

    private static boolean isOneVarDeclaration(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.VAR_DECLARATION}) && ((VariableDeclarationTree)tree).variables().size() == 1;
    }

    private static Integer getInteger(ExpressionTree expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.NUMERIC_LITERAL})) {
            LiteralTree literal = (LiteralTree)expression;
            try {
                Integer decoded = Integer.decode(literal.value());
                return decoded;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    private int checkForUpdateByOne(ExpressionTree update) {
        if (update.is(new Tree.Kind[]{Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.PREFIX_INCREMENT}) || update.is(new Tree.Kind[]{Tree.Kind.PLUS_ASSIGNMENT}) && EqualInForLoopTerminationCheck.isUpdateOnOneWithAssign(update)) {
            return 1;
        }
        if (update.is(new Tree.Kind[]{Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.PREFIX_DECREMENT}) || update.is(new Tree.Kind[]{Tree.Kind.MINUS_ASSIGNMENT}) && EqualInForLoopTerminationCheck.isUpdateOnOneWithAssign(update)) {
            return -1;
        }
        return 0;
    }

    private boolean isUpdateIncDec(ExpressionTree update) {
        boolean result = false;
        if (update.is(new Tree.Kind[]{Tree.Kind.COMMA_OPERATOR})) {
            BinaryExpressionTree commaExpressions = (BinaryExpressionTree)update;
            result = this.isUpdateIncDec(commaExpressions.leftOperand()) && this.isUpdateIncDec(commaExpressions.rightOperand());
        } else if (update.is(new Tree.Kind[]{Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.PREFIX_INCREMENT}) || update.is(new Tree.Kind[]{Tree.Kind.PLUS_ASSIGNMENT})) {
            result = true;
        } else if (update.is(new Tree.Kind[]{Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.PREFIX_DECREMENT}) || update.is(new Tree.Kind[]{Tree.Kind.MINUS_ASSIGNMENT})) {
            result = true;
        }
        return result;
    }

    private static boolean isUpdateOnOneWithAssign(ExpressionTree update) {
        if (update.is(new Tree.Kind[]{Tree.Kind.PLUS_ASSIGNMENT, Tree.Kind.MINUS_ASSIGNMENT})) {
            ExpressionTree rightExpression = ((AssignmentExpressionTree)update).expression();
            return rightExpression.is(new Tree.Kind[]{Tree.Kind.NUMERIC_LITERAL}) && "1".equals(((LiteralTree)rightExpression).value());
        }
        return false;
    }
}

