/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.ForInStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.StatementTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="ForIn", name="\"for...in\" loops should filter properties before acting on them", priority=Priority.MAJOR, tags={"bug"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class ForInCheck
extends BaseTreeVisitor {
    public void visitForInStatement(ForInStatementTree tree) {
        StatementTree statementNode = tree.statement();
        if (statementNode.is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            BlockTree block = (BlockTree)statementNode;
            StatementTree statementTree = statementNode = !block.statements().isEmpty() ? (StatementTree)block.statements().get(0) : null;
        }
        if (statementNode != null && !statementNode.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
            this.getContext().addIssue((JavaScriptCheck)this, (Tree)tree, "Insert an if statement at the beginning of this loop to filter items.");
        }
        super.visitForInStatement(tree);
    }
}

