/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.regex.Pattern;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S100", name="Function names should comply with a naming convention", priority=Priority.MINOR, tags={"convention"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="5min")
public class FunctionNameCheck
extends SquidCheck<LexerlessGrammar> {
    public static final String DEFAULT = "^[a-z][a-zA-Z0-9]*$";
    private Pattern pattern = null;
    @RuleProperty(key="format", description="Regular expression used to check the function names against.", defaultValue="^[a-z][a-zA-Z0-9]*$")
    public String format = "^[a-z][a-zA-Z0-9]*$";

    public void init() {
        this.pattern = Pattern.compile(this.format);
        this.subscribeTo(new AstNodeType[]{Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.GENERATOR_DECLARATION, Tree.Kind.GENERATOR_METHOD, Tree.Kind.METHOD});
    }

    public void visitNode(AstNode astNode) {
        String identifier = astNode.getFirstChild(new AstNodeType[]{Tree.Kind.BINDING_IDENTIFIER, Tree.Kind.IDENTIFIER_NAME}).getTokenValue();
        if (!this.pattern.matcher(identifier).matches()) {
            this.getContext().createLineViolation((CodeCheck)this, "Rename this ''{0}'' function to match the regular expression {1}", astNode, new Object[]{identifier, this.format});
        }
    }
}

